@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none"
                                        href="#">{{ $menu }}</a></li>
                                <li class="breadcrumb-item" aria-current="page">{{ $nama_menu }}</li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        @if ($data)
        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-12 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-person-plus-fill"></i> Roles ({{ $item->username }})</p>
                        </div>

                    </div>
                 
                    @if ($item->level == 'perusahaan')
                    <form action="/superadmin_master_roles/{{ $data->id }}" method="post" enctype="multipart/form-data">
                    @method('put')
                        @csrf

                        <input type="hidden" name="user_id" value="{{ $item->id }}">
                        <input type="hidden" name="divisi_id" value="0"> 
                        {{-- <input type="hidden" name="sub_divisi_id" value="0">  --}}
                        <input type="hidden" name="proyek_id" value="0"> 

                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Nama</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="" required autofocus value="{{ old('password', $item->name) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Username</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->username) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Level</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->level) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="perusahaan" class=" mb-0 teks"><i class="bi bi-reception-4"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="perusahaan_id"
                                         value="{{ old('perusahaan_id') }}">
                                         <option  value="{{ $data->perusahaan_id }}">- {{ $data->perusahaan->nama_perusahaan }} </option>
                                         @foreach ($perusahaan as $item)
                                         <option value="{{ $item->id }}">- {{ $item->nama_perusahaan }}</option>
                                         @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="d-flex justify-content-around mt-4">
                                    <button type="submit"
                                        class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                                    <a  onclick="goBack()"
                                        class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>
        
                                </div>
                            </div>
                     
                            <div class="col-6">
                               
                            </div>
                        </div>


                    </form>


                    @elseif ($item->level == 'divisi')
                    <form action="/superadmin_master_roles/{{ $data->id }}" method="post" enctype="multipart/form-data">
                        @method('put')
                        @csrf

                        <input type="hidden" name="user_id" value="{{ $item->id }}">
                        {{-- <input type="hidden" name="sub_divisi_id" value="0">  --}}
                        <input type="hidden" name="proyek_id" value="0"> 

                        

                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Nama</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->name) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Username</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->username) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Level</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->level) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>

                                

                              
                            </div>
                     
                            <div class="col-6">

                                <div class="mb-3">
                                    <label for="level" class=" mb-0 teks"><i class="bi bi-reception-4"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" id="perusahaan" name="perusahaan_id"
                                         value="{{ old('perusahaan_id') }}">
                                         <option  value="{{ $data->perusahaan_id }}" >- {{ $data->perusahaan->nama_perusahaan }} </option>
                                         @foreach ($perusahaan as $item)
                                         <option value="{{ $item->id }}">- {{ $item->nama_perusahaan }}</option>
                                         @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>


                                <div class="mb-3">
                                    <label for="divisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="divisi_id"
                                        id="divisi">
                                        <option value="{{ $data->divisi_id }}">- {{ $data->divisi->nama_divisi }}</option>
                                    </select>
                                    @error('divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                               
                            </div>
                            <div class="d-flex justify-content-around mt-4">
                                <button type="submit"
                                    class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                                <a  onclick="goBack()"
                                    class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>
    
                            </div>


                        </div>


                    </form>


                    @else

                    <form action="/superadmin_master_roles/{{ $data->id }}" method="post" enctype="multipart/form-data">
                        @method('put')
                        @csrf

                        <input type="hidden" name="user_id" value="{{ $item->id }}">

                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Nama</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->name) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Username</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->username) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Level</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->level) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
      
                            </div>
                     
                            <div class="col-6">

                                <div class="mb-3">
                                    <label for="level" class=" mb-0 teks"><i class="bi bi-reception-4"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" id="perusahaan" name="perusahaan_id"
                                         value="{{ old('perusahaan_id') }}">
                                         <option   value="{{ $data->perusahaan_id }}">- {{ $data->perusahaan->nama_perusahaan }} </option>
                                         @foreach ($perusahaan as $item)
                                         <option value="{{ $item->id }}">- {{ $item->nama_perusahaan }}</option>
                                         @endforeach
                                    </select>
                                    @error('level')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>


                                <div class="mb-3">
                                    <label for="divisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="divisi_id"
                                        id="divisi">
                                        <option value="{{ $data->divisi_id }}">- {{ $data->divisi->nama_divisi }}</option>
                                    </select>
                                    @error('divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>


                                {{-- <div class="mb-3">
                                    <label for="subdivisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Sub Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="sub_divisi_id"
                                        id="subdivisi">
                                        <option value="{{ $data->sub_divisi_id }}">- {{ $data->sub_divisi->nama_sub_divisi }}</option>
                                    </select>
                                    @error('sub_divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div> --}}

                                <div class="mb-3">
                                    <label for="proyek" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Area</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="proyek_id"
                                         value="{{ old('proyek_id') }}" id="proyek">
                                        <option  value="{{ $data->proyek_id }}">- {{ $data->proyek->nama_proyek }} </option>
                                        @foreach ($proyek as $item)
                                            <option  value="{{ $item->id }}">-
                                                {{ $item->nama_proyek }}</option>
                                        @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Proyek
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                               
                            </div>

                            <div class="d-flex justify-content-around mt-4">
                                <button type="submit"
                                    class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                                <a  onclick="goBack()"
                                    class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>
    
                            </div>


                        </div>


                    </form>

                    @endif

                </div>
            </div>
        </div>

        @else

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-12 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-person-plus-fill"></i> Roles ({{ $item->username }})</p>
                        </div>

                    </div>
                 
                    @if ($item->level == 'perusahaan')
                    <form action="/superadmin_master_roles" method="post" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="user_id" value="{{ $item->id }}">
                        <input type="hidden" name="divisi_id" value="0"> 
                        {{-- <input type="hidden" name="sub_divisi_id" value="0">  --}}
                        <input type="hidden" name="proyek_id" value="0"> 

                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Nama</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="" required autofocus value="{{ old('password', $item->name) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Username</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->username) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Level</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->level) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="perusahaan" class=" mb-0 teks"><i class="bi bi-reception-4"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="perusahaan_id"
                                         value="{{ old('perusahaan_id') }}">
                                         <option  selected disabled>- Pilih Perusahaan </option>
                                         @foreach ($perusahaan as $item)
                                         <option value="{{ $item->id }}">- {{ $item->nama_perusahaan }}</option>
                                         @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="d-flex justify-content-around mt-4">
                                    <button type="submit"
                                        class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                                    <a  onclick="goBack()"
                                        class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>
        
                                </div>

                              
                            </div>
                     
                            <div class="col-6">
                               
                            </div>
                        </div>


                    </form>


                    @elseif ($item->level == 'divisi')
                    <form action="/superadmin_master_roles" method="post" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="user_id" value="{{ $item->id }}">
                        {{-- <input type="hidden" name="sub_divisi_id" value="0">  --}}
                        <input type="hidden" name="proyek_id" value="0"> 

                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Nama</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->name) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Username</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->username) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Level</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->level) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                            </div>
                     
                            <div class="col-6">

                                <div class="mb-3">
                                    <label for="level" class=" mb-0 teks"><i class="bi bi-reception-4"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" id="perusahaan" name="perusahaan_id"
                                         value="{{ old('perusahaan_id') }}">
                                         <option selected disabled  value="">- Pilih Perusahaan </option>
                                         @foreach ($perusahaan as $item)
                                         <option value="{{ $item->id }}">- {{ $item->nama_perusahaan }}</option>
                                         @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>


                                <div class="mb-3">
                                    <label for="divisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="divisi_id"
                                        id="divisi">
                                        <option value="">-- Pilih Divisi --</option>
                                    </select>
                                    @error('divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                               
                            </div>
                            <div class="d-flex justify-content-around mt-4">
                                <button type="submit"
                                    class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                                <a  onclick="goBack()"
                                    class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>
    
                            </div>


                        </div>


                    </form>


                    @else

                    <form action="/superadmin_master_roles" method="post" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="user_id" value="{{ $item->id }}">

                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Nama</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->name) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Username</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->username) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Level</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password', $item->level) }}" disabled
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>

                            </div>
                     
                            <div class="col-6">

                                <div class="mb-3">
                                    <label for="level" class=" mb-0 teks"><i class="bi bi-reception-4"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" id="perusahaan" name="perusahaan_id"
                                         value="{{ old('perusahaan_id') }}">
                                         <option selected disabled  value="">- Pilih Perusahaan </option>
                                         @foreach ($perusahaan as $item)
                                         <option value="{{ $item->id }}">- {{ $item->nama_perusahaan }}</option>
                                         @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>


                                <div class="mb-3">
                                    <label for="divisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="divisi_id"
                                        id="divisi">
                                        <option value="">-- Pilih Divisi --</option>
                                    </select>
                                    @error('divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>


                                {{-- <div class="mb-3">
                                    <label for="subdivisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Sub Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="sub_divisi_id"
                                        id="subdivisi">
                                        <option value="">-- Pilih Sub Divisi --</option>
                                    </select>
                                    @error('sub_divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div> --}}

                                <div class="mb-3">
                                    <label for="proyek" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Area</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="proyek_id" 
                                         value="{{ old('proyek_id') }}" id="proyek">
                                        <option selected disabled value="">-- Pilih Area -- </option>
                                        @foreach ($proyek as $item)
                                            <option  value="{{ $item->id }}">-
                                                {{ $item->nama_proyek }}</option>
                                        @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Proyek
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                               
                            </div>

                            <div class="d-flex justify-content-around mt-4">
                                <button type="submit"
                                    class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                                <a onclick="goBack()"
                                    class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>
    
                            </div>


                        </div>


                    </form>

                    @endif
                   


                  

                </div>
            </div>
        </div>
            
        @endif
    

       

    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(function() {
            $('#perusahaan').on('change', function() {
                let id_perusahaan = $('#perusahaan').val();

                console.log(id_perusahaan);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getdivisi') }}",
                    data: {
                        id_perusahaan: id_perusahaan
                    },
                    cache: false,

                    success: function(msg) {
                        $('#divisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })

            $('#divisi').on('change', function() {
                let id_divisi = $('#divisi').val();

                console.log(id_divisi);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getproyek') }}",
                    data: {
                        id_divisi: id_divisi
                    },
                    cache: false,

                    success: function(msg) {
                        $('#proyek').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })
        })
    </script>
@endsection
