@extends('layouts.index')

@section('main')
    <div class="">
        <div class="pc-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="">

                                <div class="page-header-title">
                                    {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                                </div>
                                <ul class="breadcrumb">
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="#">{{ $menu }}</a></li>
                                    <li class="breadcrumb-item" aria-current="page">{{ $nama_menu }}</li>
                                </ul>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->

            <!--[ Main Content ] start-->
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="d-flex justify-content-between mx-2 py-2">
                            <div class="">
                                <form class="row" action="#">
                                    <div class="col cont">
                                        <input type="text" name="search" value="{{ request('search') }}"
                                            class="pencarian" placeholder="Cari Perusahaan">
                                    </div>
                                    <div class="col">
                                        <button type="submit" class="ms-0 tombol_search"><i class="bi bi-search"></i></button>
                                    </div>
                                </form>

                            </div>
                            <div class="d-flex align-items-center">
                                <a href="/superadmin_master_perusahaan/create" class="tombol_add"><i class="bi bi-folder-plus"></i> Add</a>
                            </div>
                        </div>
                        
                        <div>
                            <div class="mx-2 pt-3 pb-5">
                                <div class="shadow ">
                                    {{-- <div class="card-header mb-0  ">
                                        @if (session()->has('success'))
                                            <div class=" mb-0 alert alert-success alert-dismissible fade show" role="alert">
                                                <strong><i class="bi bi-check-square"></i> </strong> {{ session('success') }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                aria-label="Close"></button>
                                            </div>
                                        @endif
                                        @if (session()->has('delete'))
                                            <div class="mb-0 alert alert-danger alert-dismissible fade show" role="alert">
                                                <strong>Sukses, </strong> {{ session('delete') }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                aria-label="Close"></button>
                                            </div>
                                        @endif
                                    </div> --}}
                                    <div class="table-responsive p-1">
                                        <table class=" table table-sm align-items-center table-flush table-hover" id="dataTableHover">
                                            <thead class="thead-light">
                                                <tr class="tabel">
                                                    <th  class="">No</th>
                                                    <th  class="w-25">Kode Perusahaan</th>
                                                    <th scope="col" class="w-50">Nama Perusahaan</th>
                                                    <th scope="col" class="w-25">Gambar</th>
                                                    <th scope="col" class="text-center">Opsi</th>
                                                </tr>
                    
                                            </thead>
                    
                                            <tbody>
                                                @php
                                                $no = 1;
                                            @endphp
                                            @if (count($data))
                                                @foreach ($data as $item)
                                                    <tr class="tabel">
                                                        <td>{{ $no++ }}</td>
                                                        <td class="ps-2">{{ $item->kode_perusahaan }}</td>
                                                        <td>{{ $item->nama_perusahaan }}</td>
                                                        <td><img src="{{ asset('storage/' . $item->image) }}" class="img-fluid" width="50px"
                                                            alt=""></td>
                                                        {{-- <td>{{ $item->roles }}</td> --}}
                                                        <td class="bg-transparent d-flex flex-row text-center">
                                                            <a href="/superadmin_master_perusahaan/{{ $item->id }}"
                                                                class="badge-edit  text-light fs-6 mx-1 "><i
                                                                    class="bi bi-pencil-square"></i></a>
                                                                    <a href="/superadmin_master_perusahaan/{{ $item->id }}" class="badge-delete  text-light fs-6 border-0" data-confirm-delete="true"><i
                                                                        class="bi bi-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <div class="table-responsive">
                                                    <tr class=" text-center text-danger fw-bold">
                                                        <td colspan="6"><i class="bi bi-info-circle"></i> Perusahaan tidak ditemukan !!!</td>
                                                    </tr>
                                                </div>
                                            @endif
                    
                                              </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
               
            </div>
            <!--[ Main Content ] end-->
        </div>
    </div>

    </div>

   


    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable(); // ID From dataTable 
            $('#dataTableHover').DataTable(); // ID From dataTable with Hover
        });
    </script>
@endsection
