@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="#">{{ $menu }}</a></li>
                                <li class="breadcrumb-item" aria-current="page">{{ $nama_menu }}</li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-6 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-building "></i> Tambah Perusahaan</p>
                        </div>

                    </div>
                    {{-- <div class=" ">
            <h5 class="text-success">Total = <span class="fw-bold">Rp.1.000.000.000</span> </h5>
        </div> --}}
                    {{-- <hr class="mt-0 p-1 bg-primary rounded" width="350" ></hr> --}}
                    <form action="/superadmin_master_perusahaan/{{ $item->id }}" method="post" enctype="multipart/form-data">
                        @method('put')
                        @csrf

                        <div class="">

                            <div class="">
                                <div class="mb-4">
                                    <label for="kode_perusahaan" class="form-label teks mb-0"><i
                                            class="bi bi-building "></i> Kode Perusahaan</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('kode_perusahaan') is-invalid @enderror "
                                        name="kode_perusahaan" required autofocus value="{{ old('kode_perusahaan', $item->kode_perusahaan) }}"  onkeyup="this.value = this.value.toUpperCase()">
                                    @error('kode_perusahaan')
                                        <div class="text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Perusahaan sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="nama_perusahaan" class=" mb-0 teks"><i class="bi bi-building "></i> Nama
                                        Perusahaan</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('nama_perusahaan') is-invalid @enderror "
                                        name="nama_perusahaan" required autofocus value="{{ old('nama_perusahaan', $item->nama_perusahaan) }}"
                                        aria-label="Sizing example input" aria-describedby="inputGroup-sizing-sm" onkeyup="this.value = this.value.toUpperCase()">
                                    @error('nama_perusahaan')
                                        <div class="text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Perusahaan sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="image" class="form-label fw-bold">Gambar</label>
                                    <input type="hidden" name="imagelama" value="{{ $item->image }}" >
                                    @if ($item->image)
                                        <img src="{{ asset('storage/' . $item->image) }}" class="img-preview img-fluid col-sm-5 mb-2 d-block" >
                                    @else
                                        <img class="img-preview img-fluid col-sm-5 mb-2" >
                                    @endif 
                                    <input class="form-control mb-0  @error('image') is-invalid @enderror" type="file" id="image" name="image" onchange="previewImage()" >
                                    @error('image')
                                    <div class="alert alert-danger" role="alert">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                    <p class="m-0" >Maksimal 5 MB</p>
                                </div>
                            

                            </div>


                        </div>



                        <div class="d-flex justify-content-around mt-4">
                            <button type="submit" class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                            <a onclick="goBack()" class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>

                        </div>

                    </form>

                </div>
            </div>
        </div>





    </div>

    {{-- <script>
        const judul = document.querySelector('#judul')
        const slug = document.querySelector('#slug')

        judul.addEventListener('change', function() {
            fetch('/adminberita/checkSlug?judul=' + judul.value);
            .then(response => response.json())
                .then(data => slug.value = data.slug)
        })
    </script> --}}
@endsection
