@extends('layouts.index')

@section('main')
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title text-hijau" id="exampleModalLabel"><i class="bi bi-ui-checks-grid"></i> Cari Barang
                    </h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="/superadmin_1_gs_stok/create">
                        <div class="mb-3">
                            {{-- <label for="recipient-name" class="col-form-label">Masukkan Kode Barang</label> --}}
                            <input type="text" name="cari_barang" placeholder="Masukkan Kode Barang" required
                                class="form-control @error('cari_barang') is-invalid @enderror ">
                            <p class="text-primary fst-italic">* Isi Kode Barang dengan lengkap</p>
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="tombol_add">Cari Barang</button>
                </div>
                </form>

            </div>
        </div>
    </div>


    <div class="">
        <div class="pc-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="">

                                <div class="page-header-title">
                                    {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                                </div>
                                <ul class="breadcrumb">
                                    <li class="breadcrumb-item"><a class="text-decoration-none"
                                            href="/superadmin_1">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a class="text-decoration-none"
                                            href="#">{{ $menu }}</a></li>
                                    <li class="breadcrumb-item"><a href="" onclick="goBack()"
                                            class="text-decoration-none" href="#">{{ $nama_menu }}</a></li>
                                    <li class="breadcrumb-item" aria-current="page"> Konstruksi / {{ $kategori_menu }}</li>
                                </ul>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->

            <!--[ Main Content ] start-->
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div>
                            <div class="mx-2 ">
                                <div class=" ">
                                    <div class="card-header mb-0  ">
                                        @if (session()->has('success'))
                                            <div class=" mb-0 alert alert-success alert-dismissible fade show"
                                                role="alert">
                                                <strong><i class="bi bi-check-square"></i> </strong>
                                                {{ session('success') }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                    aria-label="Close"></button>
                                            </div>
                                        @endif
                                        @if (session()->has('delete'))
                                            <div class="mb-0 alert alert-danger alert-dismissible fade show" role="alert">
                                                <strong>Sukses, </strong> {{ session('delete') }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                    aria-label="Close"></button>
                                            </div>
                                        @endif
                                    </div>

                                    <div class="row">
                                        <div class="col-12">
                                            <label for="" class="fw-bold">Filter Tanggal</label>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <input type="date" name="tglawal" class="pencarian "
                                                    placeholder="Tanggal Awal">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <input type="date" name="tglakhir" class="pencarian"
                                                    placeholder="Tanggal Akhir">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <button class="tombol_search" onclick="filter()"><i class="bi bi-funnel"></i>
                                                Filter</button>
                                            <button class="tombol_reset" onclick="reset()"><i class="bi bi-stars"></i>
                                                Reset</button>
                                            <button class="tombol_print" onclick="print()">
                                                <i class="bi bi-printer"></i>
                                                Print</button>
                                            <button class="tombol_pdf" onclick="pdf()"><i class="bi bi-filetype-pdf"></i>
                                                PDF</button>
                                        </div>
                                    </div>


                                    <div class="table-responsive">
                                        <table id="table-1"
                                            class="display nowrap table table-sm table-bordered  table-striped table-hover text-nowrap "
                                            style="width:100%">
                                            <thead>
                                                <th class="border-bottom-0" width="1%">No</th>
                                                <th class="border-bottom-0">Kode Barang</th>
                                                <th class="border-bottom-0">Nama Barang</th>
                                                <th class="border-bottom-0">Merek</th>
                                                <th class="border-bottom-0">Jumlah Masuk</th>
                                                <th class="border-bottom-0">Jumlah Keluar</th>
                                                <th class="border-bottom-0">Total Stok</th>
                                                <th class="border-bottom-0">Opsi</th>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>





                                </div>
                            </div>
                        </div>


                    </div>
                </div>


            </div>




            <!--[ Main Content ] end-->

        </div>



    </div>

    </div>

    {{-- <script>
        $(document).ready(function() {
            $('#dataTable').DataTable(); // ID From dataTable 
            $('#dataTableHover').DataTable(); // ID From dataTable with Hover
        });
    </script> --}}
@endsection


<script>
    $(document).ready(function() {
        // BOOTSTRAP DATEPICKER
        $('.datepicker-date').bootstrapdatepicker({
            format: "yyyy-mm-dd",
            viewMode: "date",
            autoclose: true,
        })
    })
</script>


@section('scripts')
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            getData();
        });

        function getData() {
            //datatables
            table = $('#table-1').DataTable({
                language: {
                    entries: ' Data',
                    search: 'Pencarian',
                    // url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/de-DE.json'
                },

                "processing": true,
                "serverSide": true,
                "info": true,
                "order": [],
                "scrollX": true,
                "stateSave": true,
                "lengthMenu": [
                    [5, 10, 25, 50, 100, 200],
                    [5, 10, 25, 50, 100, 200]
                ],
                "pageLength": 10,

                lengthChange: true,

                "ajax": {
                    "url": "{{ route('lap.stok.barang') }}",
                    "data": function(d) {
                        d.tglawal = $('input[name="tglawal"]').val();
                        d.tglakhir = $('input[name="tglakhir"]').val();
                    }
                },

                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        searchable: false
                    },
                    {
                        data: 'kode_barang',
                        name: 'kode_barang',
                    },
                    {
                        data: 'nama_barang',
                        name: 'nama_barang',
                    },
                   
                    {
                        data: 'merek',
                        name: 'merek',
                    },
                    {
                        data: 'jmlmasuk',
                        name: 'kode_barang',
                        orderable: false,
                    },
                    {
                        data: 'jmlkeluar',
                        name: 'kode_barang',
                        searchable: false,
                        orderable: false,
                    },
                    {
                        data: 'totalstok',
                        name: 'kode_barang',
                        searchable: false,
                        orderable: false,
                    },
                    {
                        data: 'opsi',
                        name: 'opsi',
                        searchable: false,
                        orderable: false,
                    },


                ],

                columnDefs: [{
                        targets: 0,
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 14px" >' + data + '</div>';
                            }
                            return data;
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data =
                                    '<a style="font-size: 14px" class="fw-bold text-decoration-none" href="/sa_master_konstruksi_stok_barang/show/' +
                                    encodeURIComponent(data) + '">' + data + '</a>';
                            }

                            return data;
                        }
                    },
                    {
                        targets: 2,
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 14px" >' + data + '</div>';
                            }
                            return data;
                        }
                    },
                    {
                        targets: 3,
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 14px" >' + data + '</div>';
                            }
                            return data;
                        }
                    },
                    {
                        targets: 4,
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 14px" >' + data + '</div>';
                            }
                            return data;
                        }
                    },
                    {
                        targets: 5,
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 14px" >' + data + '</div>';
                            }
                            return data;
                        }
                    },
                    {
                        targets: 7,
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 12px" >' + data + '</div>';
                            }

                            return data;
                        }
                    },

                ],



            });
        }

        function filter() {
            var tglawal = $('input[name="tglawal"]').val();
            var tglakhir = $('input[name="tglakhir"]').val();
            if (tglawal != '' && tglakhir != '') {
                table.ajax.reload(null, false);
            } else {
                validasi("Isi dulu Form Filter Tanggal!", 'warning');
            }

        }

        function reset() {
            $('input[name="tglawal"]').val('');
            $('input[name="tglakhir"]').val('');
            table.ajax.reload(null, false);
        }

        function print() {
            var tglawal = $('input[name="tglawal"]').val();
            var tglakhir = $('input[name="tglakhir"]').val();
            if (tglawal != '' && tglakhir != '') {
                window.open(
                    "/bms_aset/print_all/" + tglawal + "&" + tglakhir,
                    '_blank'
                );
            } else {
                alert("Pilih Filter Tanggal !");
            }
        }




        function validasi(judul, status) {
            swal({
                title: judul,
                type: status,
                confirmButtonText: "Iya."
            });
        }
    </script>
@endsection
