@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none"
                                        href="#">{{ $menu }}</a></li>
                                <li class="breadcrumb-item" aria-current="page">{{ $nama_menu }}</li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-12 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-dropbox"></i> Tambah Barang</p>
                        </div>

                    </div>
                    {{-- <div class=" ">
            <h5 class="text-success">Total = <span class="fw-bold">Rp.1.000.000.000</span> </h5>
        </div> --}}
                    {{-- <hr class="mt-0 p-1 bg-primary rounded" width="350" ></hr> --}}
                    <form action="/sa_master_gs_konstruksi_barang/{{ $data->id }}" method="post" enctype="multipart/form-data">
                        @method('put')
                        @csrf

                        <div class="row">

                            <div class="col-6">


                                <div class="mb-3">
                                    <label for="perusahaan" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="perusahaan_id"
                                        id="perusahaan" value="{{ old('perusahaan_id') }}">
                                        <option value="{{ $data->perusahaan_id }}">- {{ $data->perusahaan->nama_perusahaan }}- </option>
                                        @foreach ($perusahaan as $item)
                                            <option id="perusahaan" value="{{ $item->id }}">-
                                                {{ $item->nama_perusahaan }}</option>
                                        @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="divisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="divisi_id"
                                        id="divisi">
                                        <option value="{{ $data->divisi_id }}">- {{ $data->divisi->nama_divisi }}-</option>
                                    </select>
                                    @error('divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-0">
                                    <label for="subdivisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Sub Divisi</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="sub_divisi_id"
                                        id="subdivisi">
                                        <option value="{{ $data->sub_divisi_id }}">- {{ $data->sub_divisi->nama_sub_divisi }}-</option>
                                    </select>
                                    <p class="text-light fst-italic mb-0">* Isi dengan - jika kosong</p>

                                    @error('sub_divisi_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="proyek" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Proyek</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="proyek_id"
                                         value="{{ old('proyek_id') }}">
                                        <option value="{{ $data->proyek_id }}">- {{ $data->proyek->nama_proyek }} </option>
                                        @foreach ($proyek as $item)
                                            <option  value="{{ $item->id }}">-
                                                {{ $item->nama_proyek }}</option>
                                        @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Proyek
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>

                               
                               
                            </div>


                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="kode_barang" class="form-label teks mb-0"><i class="bi bi-dropbox"></i> Kode Barang</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('kode_barang') is-invalid @enderror "
                                        name="kode_barang" required autofocus value="{{ old('kode_barang', $data->kode_barang) }}"
                                        onkeyup="this.value = this.value.toUpperCase()">
                                    @error('kode_barang')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Kode Barang sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="nama_barang" class="form-label teks mb-0"><i class="bi bi-dropbox"></i> Nama
                                        Barang</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('nama_barang') is-invalid @enderror "
                                        name="nama_barang" required autofocus value="{{ old('nama_barang', $data->nama_barang) }}"
                                        onkeyup="this.value = this.value.toUpperCase()">
                                    @error('nama_barang')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Nama wajib di isi !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-0">
                                    <label for="merek" class="form-label teks mb-0"><i class="bi bi-dropbox"></i> Merek</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('merek') is-invalid @enderror "
                                        name="merek" required autofocus value="{{ old('merek', $data->merek) }}"
                                        onkeyup="this.value = this.value.toUpperCase()">
                                        <p class="text-primary fst-italic mb-0">* Isi dengan - jika kosong</p>
                                    @error('merek')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Merek tidak boleh kosong !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="kategori" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Kategori</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="kategori_id"
                                        id="kategori_id" value="{{ old('kategori_id') }}">
                                        <option value="{{ $data->kategori_id }}">- {{ $data->kategori->nama_kategori }} - </option>
                                        @foreach ($kategori as $item)
                                            <option value="{{ $item->id }}">-
                                                {{ $item->nama_kategori }}</option>
                                        @endforeach
                                    </select>
                                    @error('kategori_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Kategori
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                               
                            </div>
                        </div>




                        <div class="d-flex justify-content-around mt-4">
                            <button type="submit"
                                class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                            <a href="" onclick="goBack()"
                                class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>

                        </div>

                    </form>

                </div>
            </div>
        </div>

    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(function() {
            $('#perusahaan').on('change', function() {
                let id_perusahaan = $('#perusahaan').val();

                console.log(id_perusahaan);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getdivisi') }}",
                    data: {
                        id_perusahaan: id_perusahaan
                    },
                    cache: false,

                    success: function(msg) {
                        $('#divisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })

            $('#divisi').on('change', function() {
                let id_divisi = $('#divisi').val();

                console.log(id_divisi);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getsubdivisi') }}",
                    data: {
                        id_divisi: id_divisi
                    },
                    cache: false,

                    success: function(msg) {
                        $('#subdivisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })
        })
    </script>
@endsection
