<!DOCTYPE html>
<html lang="en">

<?php
use App\Models\Kendaraan\Kendaraan_In;
use App\Models\Kendaraan\Kendaraan_Out;
use Carbon\Carbon;
?>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="{{$web->web_deskripsi}}">
    <meta name="author" content="{{$web->web_nama}}">
    <meta name="keywords" content="">
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">


    <!-- FAVICON -->
    @if($web->web_logo == '' || $web->web_logo == 'default.png')
    <link rel="shortcut icon" type="image/x-icon" href="{{url('/assets/default/web/default.png')}}" />
    @else
    <link rel="shortcut icon" type="image/x-icon" href="{{asset('storage/web/' . $web->web_logo)}}" />
    @endif

    <title>{{ $item->proyek->divisi->perusahaan->kode_perusahaan }}-ASET-BRG_ALL{{Carbon::parse($tglawal)->translatedFormat('d-m-Y')}}/{{Carbon::parse($tglakhir)->translatedFormat('d-m-Y')}}</title>

    <style>
        * {
            font-family: Arial, Helvetica, sans-serif;
        }
        #img {
            width: 200px;
            height: 200px;
        }

        #table1 {
            border-collapse: collapse;
            width: 100%;
            margin-top: 32px;
        }

        #table1 td,
        #table1 th {
            border: 1px solid #2c3e50;
            padding: 8px;
        }

        #table1 th {
            padding-top: 12px;
            padding-bottom: 12px;
            color: black;
            font-size: 12px;
        }

        #table1 td {
            font-size: 11px;
        }

        .font-medium {
            font-weight: 500;
        }

        .font-bold {
            font-weight: 600;
        }

        .d-2 {
            display: flex;
            align-items: flex-start;
            margin-top: 32px;
        }
    </style>

</head>

<body onload="window.print()">

    <center>
        @if($web->web_logo == '' || $web->web_logo == 'default.png')
        <img src="{{asset('storage/' . $item->proyek->divisi->perusahaan->image)}}" width="150px" alt="">
        @else
        <img src="{{asset('storage/' . $item->proyek->divisi->perusahaan->image)}}" width="80px" alt="">
        @endif
    </center>

    <center>
        <h5 class="fs-6 fw-bold mt-2">{{ $item->proyek->divisi->nama_divisi }}</h5>
        <h5 class="fs-6">{{ $item->proyek->nama_proyek }}</h5>
        <h5 class="fs-6">Laporan Keluar-Masuk {{ $item->nama_sub_divisi }}</h5>
        @if($tglawal == '')
        <h4 class="">Semua Tanggal</h4>
        @else
        {{-- <h4 class="font-medium">{{Carbon::parse($tglawal)->translatedFormat('d F Y')}} - {{Carbon::parse($tglakhir)->translatedFormat('d F Y')}}</h4> --}}
        @endif
        Tanggal {{Carbon::parse($tglawal)->translatedFormat('d-m-Y')}} s/d {{Carbon::parse($tglakhir)->translatedFormat('d-m-Y')}}
    </center>


    <table border="1" id="table1">
        <thead>
            <tr>
                <th align="center" width="1%">NO</th>
                <th>KODE KENDARAAN</th>
                <th>NAMA KENDARAAN</th>
                <th>MEREK</th>
                <th class="text-center">JUMLAH MASUK</th>
                <th class="text-center">JUMLAH KELUAR</th>
                <th class="text-center">TOTAL STOK</th>
            </tr>
        </thead>
        <tbody>
            @php $no=1; @endphp
            @foreach($data as $d)
            @php
                // Barang Masuk
                $jmlmasuk = Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')->whereBetween('tanggal', [$tglawal, $tglakhir])->where('kendaraan__ins.kendaraan_id', '=', $d->id)->sum('kendaraan__ins.jumlah');
                      
                  
                //    Barang Keluar
                              
                $jmlkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')->whereBetween('tanggal', [$tglawal, $tglakhir])->where('kendaraan__outs.kendaraan_id', '=', $d->id)->sum('kendaraan__outs.jumlah');
                       
                // Total Barang
                $brgmasuk = Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')->where('kendaraan__ins.kendaraan_id', '=', $d->id)->sum('kendaraan__ins.jumlah');
            
                $brgkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')->where('kendaraan__outs.kendaraan_id', '=', $d->id)->sum('kendaraan__outs.jumlah');

                $jumlah = $brgmasuk - $brgkeluar
                   

            @endphp


            <tr>
                <td align="center">{{$no++}}</td>
                <td>{{$d->kode_kendaraan}}</td>
                <td>{{$d->nama_kendaraan}}</td>
                <td>{{$d->merek}}</td>
                <td align="center">{{$jmlmasuk}}</td>
                <td align="center">{{$jmlkeluar}}</td>
                <td align="center">{{$jumlah }}</td>
               
            </tr>
            @endforeach
        </tbody>
    </table>

</body>

</html>