@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/admin">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/admin_menu">{{ $data->proyek->divisi->nama_divisi }}</a></li>
                                <li class="breadcrumb-item "  aria-current="page"><a  class="text-decoration-none" href="/kendaraan/kendaraan/{{ $data->sub_divisi_id }}"> {{ $data->sub_divisi->nama_sub_divisi }}</a></li>
                                <li class="breadcrumb-item "  aria-current="page"><a  class="text-decoration-none" type="button" onclick="goBack()">KEMBALI</a></li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-12 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-car-front"></i> Edit Kendaraan</p>
                        </div>

                    </div>
                    {{-- <div class=" ">
            <h5 class="text-success">Total = <span class="fw-bold">Rp.1.000.000.000</span> </h5>
        </div> --}}
                    {{-- <hr class="mt-0 p-1 bg-primary rounded" width="350" ></hr> --}}
                    <form action="/kendaraan/kendaraan/update/{{ $data->id }}/{{ $data->sub_divisi_id }}" method="post" enctype="multipart/form-data">
                        @method('put')
                        @csrf

                        <div class="row">

                            <div class="col-6">
                                <div class="mb-3">
                                    <div class="mb-0">
                                        <label for="kode_barang" class="form-label teks mb-0"><i class="bi bi-dropbox"></i>
                                            Perusahaan</label>
                                        <input type="text" placeholder=""
                                            class="form-control form-control-sm rounded-pill @error('kode_barang') is-invalid @enderror "
                                            name="" required autofocus
                                            value="{{ $data->perusahaan->nama_perusahaan }}"
                                            onkeyup="this.value = this.value.toUpperCase()" disabled>
                                            <p class="text-light mb-0 fst-italic">* Isi dengan - jika kosong</p>
                                     
                                    </div>
                                    <div class="mb-3">
                                        <label for="kode_barang" class="form-label teks mb-0"><i class="bi bi-dropbox"></i>
                                            Divisi</label>
                                        <input type="text" placeholder=""
                                            class="form-control form-control-sm rounded-pill @error('kode_barang') is-invalid @enderror "
                                            name="" required autofocus
                                            value="{{ $data->divisi->nama_divisi }}"
                                            onkeyup="this.value = this.value.toUpperCase()" disabled>
                                     
                                    </div>
                                    <div class="mb-0">
                                        <label for="kode_barang" class="form-label teks mb-0"><i class="bi bi-dropbox"></i>
                                            Proyek Area</label>
                                        <input type="text" placeholder=""
                                            class="form-control form-control-sm rounded-pill @error('kode_barang') is-invalid @enderror "
                                            name="" required autofocus
                                            value="{{ $data->proyek->nama_proyek }}"
                                            onkeyup="this.value = this.value.toUpperCase()" disabled>
                                            <p class="text-light mb-0 fst-italic">* Isi dengan - jika kosong</p>
                                      
                                    </div>
                                    <div class="mb-3">
                                        <label for="kode_barang" class="form-label teks mb-0"><i class="bi bi-dropbox"></i>
                                            Sub Divisi</label>
                                        <input type="text" placeholder=""
                                            class="form-control form-control-sm rounded-pill @error('kode_barang') is-invalid @enderror "
                                            name="" required autofocus
                                            value="{{ $data->sub_divisi->nama_sub_divisi }}"
                                            onkeyup="this.value = this.value.toUpperCase()" disabled>
                                    </div>
                                </div>
                            </div>


                            <div class="col-6">
                                <div class="mb-0">
                                    <label for="kode_barang" class="form-label teks mb-0"><i class="bi bi-dropbox"></i> Kode Kendaraan</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('kode_kendaraan') is-invalid @enderror "
                                        name="kode_kendaraan" required autofocus value="{{ old('kode_kendaraan', $data->kode_kendaraan) }}"
                                        onkeyup="this.value = this.value.toUpperCase()">
                                        {{-- <p class="text-primary mb-0 fst-italic">* Isi dengan - jika kosong</p> --}}
                                    @error('kode_kendaraan')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Kode Kendaraan sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                    <p class="text-primary mb-0 fst-italic">* Tidak Boleh menggunakan spasi</p>

                                </div>
                                <div class="mb-3">
                                    <label for="nama_kendaraan" class="form-label teks mb-0"><i class="bi bi-dropbox"></i> Nama
                                        Kendaraan</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('nama_kendaraan') is-invalid @enderror "
                                        name="nama_kendaraan" required autofocus value="{{ old('nama_kendaraan', $data->nama_kendaraan) }}"
                                        onkeyup="this.value = this.value.toUpperCase()">
                                    @error('nama_barang')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Nama wajib di isi !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-0">
                                    <label for="merek" class="form-label teks mb-0"><i class="bi bi-dropbox"></i> Merek</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('merek') is-invalid @enderror "
                                        name="merek" required autofocus value="{{ old('merek', $data->merek) }}"
                                        onkeyup="this.value = this.value.toUpperCase()">
                                        <p class="text-primary fst-italic mb-0">* Isi dengan - jika kosong</p>
                                    @error('merek')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Merek tidak boleh kosong !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="kategori" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                        Kategori</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="kategori_id"
                                        id="kategori_id" value="{{ old('kategori_id') }}">
                                        <option value="{{ $data->kategori_id }}">- {{ $data->kategori->nama_kategori }} - </option>
                                        @foreach ($kategori as $item)
                                            <option value="{{ $item->id }}">-
                                                {{ $item->nama_kategori }}</option>
                                        @endforeach
                                    </select>
                                    @error('kategori_id')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Kategori
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                               
                            </div>
                        </div>




                        <div class="d-flex justify-content-around mt-4">
                            <button type="submit"
                                class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                            <a href="" onclick="goBack()"
                                class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>

                        </div>

                    </form>

                </div>
            </div>
        </div>

    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(function() {
            $('#perusahaan').on('change', function() {
                let id_perusahaan = $('#perusahaan').val();

                console.log(id_perusahaan);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getdivisi') }}",
                    data: {
                        id_perusahaan: id_perusahaan
                    },
                    cache: false,

                    success: function(msg) {
                        $('#divisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })

            $('#divisi').on('change', function() {
                let id_divisi = $('#divisi').val();

                console.log(id_divisi);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getsubdivisi') }}",
                    data: {
                        id_divisi: id_divisi
                    },
                    cache: false,

                    success: function(msg) {
                        $('#subdivisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })
        })
    </script>
@endsection
