@extends('layouts.index')

@section('main')
    <div class="">
        <div class="pc-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="">

                                <div class="page-header-title">
                                    {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                                </div>
                                <ul class="breadcrumb">
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="#">{{ $menu }}</a></li>
                                    <li class="breadcrumb-item"><a type="button" onclick="goBack()" class="text-decoration-none" href="#">{{ $nama_menu }}</a></li>
                                    <li class="breadcrumb-item" aria-current="page">{{ $kategori_menu }} / {{ $proyek->nama_proyek }}</li>
                                </ul>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->

            <!--[ Main Content ] start-->
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="d-flex justify-content-between mx-2 py-2">
                            <div class="">
                                <form class="row" action="#">
                                    <div class="col cont">
                                        <input type="text" name="search" value="{{ request('search') }}"
                                            class="pencarian" placeholder="Cari barang ..">
                                    </div>
                                    <div class="col">
                                        <button type="submit" class="ms-0 tombol_search"><i class="bi bi-search"></i></button>
                                    </div>
                                </form>

                            </div>
                            <div class="d-flex align-items-center">
                                <a href="/superadmin_master_gs_barang" class="tombol_back me-2"><i class="bi bi-folder-plus"></i> Kembali</a>
                                <a href="/superadmin_master_gs_barang/create" class="tombol_add"><i class="bi bi-folder-plus"></i> Tambah</a>
                            </div>
                        </div>
                        
                        <div>
                            <div class="mx-2 pt-3 pb-5">
                                <div class="shadow ">
                              
                                    <div class="table-responsive p-1">
                                        <table class="table table-sm table-striped table-hover text-nowrap" >
                                            <thead class="thead-light">
                                                <tr class="tabel table-active">
                                                    <th  class="">No</th>
                                                    <th scope="col" class="">Kode Barang</th>
                                                    <th scope="col" class="">Nama Barang</th>
                                                    <th scope="col" class="">Merek</th>
                                                    <th scope="col" class="text-center">Kategori</th>
                                                    <th scope="col" class="text-center">Sub Divisi</th>
                                                    <th scope="col" class="text-center">Proyek</th>
                                                    <th scope="col" class="text-center">Divisi</th>
                                                    <th scope="col" class="text-center">Perusahaan</th>
                                                    <th scope="col" class="text-center">Opsi</th>
                                                 
                                                </tr>
                    
                                            </thead>
                    
                                            <tbody>
                                                @php
                                                $no = 1;
                                            @endphp
                                            @if (count($data))
                                                @foreach ($data as $item)
                                                    <tr class="tabel tabel-1  ">
                                                        <th scope="row">{{ $no++ }}</th>
                                                        <td scope="row"><a href="/superadmin_master_gs_barang/{{ $item->id }}" class="text-decoration-none">{{ $item->kode_barang }}</a></td>
                                                        <td scope="row">{{ $item->nama_barang }}</td>
                                                        <td scope="row">{{ $item->merek }}</td>
                                                        <td scope="row" class="text-center">{{ $item->kategori->nama_kategori }}</td>
                                                        <td scope="row" class="text-center">{{ $item->sub_divisi->nama_sub_divisi}}</td>
                                                        <td scope="row" class="text-center">{{ $item->proyek->nama_proyek}}</td>
                                                        <td scope="row" class="text-center">{{ $item->divisi->nama_divisi }}</td>
                                                        <td scope="row" class="text-center">{{ $item->perusahaan->kode_perusahaan }}</td>
                                                        {{-- <td>{{ $item->roles }}</td> --}}
                                                        <td class="bg-transparent d-flex flex-row text-center">
                                                           

                                                            <a href="/superadmin_master_gs_barang/{{ $item->id }}"
                                                                class="badge-edit text-light mx-1 "><i
                                                                    class="bi bi-pencil-square"></i></a>
                                                                    <a href="/superadmin_master_gs_barang/{{ $item->id }}" class="badge-delete  text-light fs-6 border-0" data-confirm-delete="true"><i
                                                                        class="bi bi-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <div class="table-responsive">
                                                    <tr class=" text-center text-danger fw-bold">
                                                        <td colspan="6"><i class="bi bi-info-circle"></i> Barang tidak ditemukan !!!</td>
                                                    </tr>
                                                </div>
                                            @endif
                    
                                              </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex bd-highlight mx-3 mb-3 ">
                            <div class=" ">
                                <p class="teks-halaman mb-0">Halaman : {{ $data->currentPage() }} </p>
                                <p class="teks-halaman mb-0">Jumlah Data : {{ $data->total() }} </p>
                                <p class="teks-halaman mb-0">Data Per Halaman : {{ $data->perPage() }}</p>
                            </div>
                            <div class="ms-auto p-2">
                                {{ $data->links() }}
                            </div>
                        </div>

                        </div>

                       
                    </div>
                </div>
               
                
            </div>


            <!--[ Main Content ] end-->
        
        </div>

        

    </div>

    </div>

   


    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable(); // ID From dataTable 
            $('#dataTableHover').DataTable(); // ID From dataTable with Hover
        });
    </script>
@endsection
