<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kendaraan__outs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perusahaan_id');
            $table->foreignId('divisi_id');
            $table->foreignId('proyek_id');
            $table->foreignId('sub_divisi_id');
            $table->foreignId('kendaraan_id');
            $table->foreignId('kendaraan_in_id');
            $table->string('no_aset');
            $table->string('jumlah');
            $table->string('penerima');
            $table->string('nik');
            $table->string('pemakai');
            $table->string('n_divisi');
            $table->string('ket_plat');
            $table->string('ket_stnk');
            $table->string('lokasi');
            $table->string('tanggal');
            $table->string('keterangan');
            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kendaraan__outs');
    }
};
