<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventaris__ins', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perusahaan_id');
            $table->foreignId('divisi_id');
            $table->foreignId('proyek_id');
            $table->foreignId('sub_divisi_id');
            $table->foreignId('inventaris_id');
            $table->string('aset');
            $table->string('nomor_seri');
            $table->string('jumlah');
            $table->string('satuan');
            $table->string('penerima');
            $table->string('nik');
            $table->string('suplayer');
            $table->string('tanggal');
            $table->string('lokasi');
            $table->string('keterangan');
            $table->string('image');
            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventaris__ins');
    }
};
