<?php

namespace App\Models\Inventaris;

use App\Models\Kategori;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Perawatan_Riwayat extends Model
{
    use HasFactory;

    
    protected $guarded = ['id'];


    public function perusahaan()
    {
        return $this->belongsTo(Perusahaan::class);
    }
    public function divisi()
    {
        return $this->belongsTo(Divisi::class);
    }
    public function sub_divisi()
    {
        return $this->belongsTo(Sub_Divisi::class);
    }
    public function kategori()
    {
        return $this->belongsTo(Kategori::class);
    }
    public function proyek()
    {
        return $this->belongsTo(Proyek::class);
    }

    public function inventaris()
    {
        return $this->belongsTo(Inventaris::class);
        // return $this->belongsTo(Gs_Barangs::class, 'gs_barang_id');
    }

    public function inventaris_out()
    {
        return $this->belongsTo(Inventaris_Out::class);
    }
}
