<?php

namespace App\Models\Gs;

use App\Models\Kategori;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gs_Barangs extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function gs_in_barang()
    {
        return $this->hasMany(Gs_In_Barang::class);
    }
    public function gs_out_barang()
    {
        return $this->hasMany(gs_out_barang::class);
    }

    public function perusahaan()
    {
        return $this->belongsTo(Perusahaan::class);
    }
    public function divisi()
    {
        return $this->belongsTo(Divisi::class);
    }
    public function sub_divisi()
    {
        return $this->belongsTo(Sub_Divisi::class);
    }
    public function kategori()
    {
        return $this->belongsTo(Kategori::class);
    }
    public function proyek()
    {
        return $this->belongsTo(Proyek::class);
    }
}
