<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use Illuminate\Http\Request;

class Superadmin_Proyek_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Proyek::orderBy('id', 'asc');

        if (request('search')) {
            $data->where('nama_proyek', 'like', '%' . request('search') . '%');
        }

        return view('superadmin.proyek.index', [
            'menu' => 'Master Data',
            'nama_menu' => 'Proyek',
            'data' => $data->paginate(),

            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('superadmin.proyek.add', [
            'menu' => 'Master Data',
            'nama_menu' => 'Proyek',
            'perusahaan' => Perusahaan::all(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'divisi_id' => 'required',
            'nama_proyek' => 'required'
        ]);

        Proyek::create($data);
        return redirect('superadmin_master_proyek')->with('toast_success', 'Proyek Ditambhakan ');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('superadmin.proyek.edit', [
            'menu' => 'Master Data',
            'nama_menu' => 'Proyej',
            'perusahaan' => Perusahaan::all(),
            'item' => Proyek::find($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            'divisi_id' => 'required',
            'nama_proyek' => 'required'
        ]);

        Proyek::where('id', $id)->update($data);
        return redirect('superadmin_master_proyek')->with('toast_success', 'Data Di Update');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Proyek::destroy($id);
        return redirect('superadmin_master_proyek')->with('toast_success', 'Perusahaan Divisi Dihapus');

    }
}
