<?php

namespace App\Http\Controllers\Superadmin\Superadmin_Master;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Perusahaan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class Superadmin_Master_Perusahaan_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Perusahaan::latest();

        if(request('search')) {
            $data->where('kode_perusahaan', 'like', '%'. request('search') . '%' )
                    ->orWhere('nama_perusahaan', 'like', '%'. request('search') . '%' ) ;
        }

        return view('superadmin.superadmin_master.perusahaan.index', [
            'menu' => 'Master Data',
            'nama_menu' => 'Perusahaan',
            'data' => $data->paginate(),


            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('superadmin.superadmin_master.perusahaan.add', [
            'menu' => 'Master Data',
            'nama_menu' => 'Perusahaan',
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'kode_perusahaan' => 'required|unique:perusahaans',
            'nama_perusahaan' => 'required',
            'image' => 'required|image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);

        if ($request->file('image')) {
            $data['image'] = $request->file('image')->store('image', 'public') ;
         }
        
        Perusahaan::create($data);
        return redirect('superadmin_master_perusahaan')->with('toast_success', 'Perusahaan telah ditambahakan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('superadmin.superadmin_master.perusahaan.edit', [
            'menu' => 'Master Data',
            'nama_menu' => 'Perusahaan',
            'item' => Perusahaan::find($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
      
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
         //
        $data = $request->validate([
            'kode_perusahaan' => 'required',
            'nama_perusahaan' => 'required',
            'image' => 'image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);

        if ($request->file('image')) {
            if ($request->imagelama) {
                Storage::delete($request->imagelama);
            }
            $data['image'] = $request->file('image')->store('image', 'public') ;
         }

        Perusahaan::where('id', $id)->update($data);
        return redirect('superadmin_master_perusahaan')->with('toast_success', 'Perusahaan telah di Update');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Perusahaan::destroy($id);
        return redirect('superadmin_master_perusahaan')->with('toast_success', 'Data Barang di Hapus !');
    }
}
