<?php

namespace App\Http\Controllers\Superadmin\Superadmin_Master;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class Superadmin_Master_Akun_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = User::orderBy('id', 'asc');

        if(request('search')) {
            $data->where('name', 'like', '%'. request('search') . '%' )
                    ->orWhere('username', 'like', '%'. request('search') . '%' ) ;
        }

        return view('superadmin.superadmin_master.akun.index', [
            'menu' => 'Master Data',
            'nama_menu' => 'Akun',
            'data' => $data->paginate(),


            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('superadmin.superadmin_master.akun.add', [
            'menu' => 'Master Data',
            'nama_menu' => 'Akun',
            'perusahaan' => Perusahaan::all(),
            'proyek' => Proyek::all()
         
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'name' => 'required|unique:users',
            'username' => 'required|unique:users',
            'password' => 'required|min:4',
            'level' => 'required',
        ]);

        $data['password'] =Hash::make($data['password']);

        User::create($data);
        return redirect('/superadmin_master_akun')->with('toast_success', 'User Berhasil ditambahkan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('superadmin.superadmin_master.akun.edit', [
            'menu' => 'Master Data',
            'nama_menu' => 'Akun',
            'item' => User::find($id)
         
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //

        $data = $request->validate([
            'name' => 'required',
            'username' => 'required',
            'password' => 'required|min:4',
            'level' => 'required',
        ]);

        $data['password'] = Hash::make($data['password']);
        User::where('id', $id)->update($data);
        return redirect('superadmin_master_akun')->with('toast_success', 'User Berhasil Di Update ');
  
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        User::destroy($id);
        return redirect('superadmin_master_akun')->with('toast_success', 'Data User di Hapus !');
 

    }
}
