<?php

namespace App\Http\Controllers\Superadmin\Perusahaan;

use App\Http\Controllers\Controller;
use App\Models\Gs\Gs_Barangs;
use App\Models\Gs\Gs_In_Barang;
use App\Models\Gs\Gs_Out_Barang;
use App\Models\Kategori;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Perusahaan_Barang_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index( $data,  $id, )
    {

    //    dd($id);
    

        $data_data = sub_divisi::where('id', $id)->first();
        // $sub_divisi = Sub_Divisi::where('proyek_id', $id)->orderBy('id', 'asc')->get();



       
    return view('superadmin.perusahaan.barang.index', [
       'data_data' =>  $data_data,
       'id' => $id,

        $title = 'Hapus Data',
        $text = "Apakah anda yakin ingin menghapus?",
        confirmDelete($title, $text),
    ]);     
   
    }

    public function show_data(Request $request, $data,  $id,)
    {

        // $data_proyek = Proyek::where('id', $id)->first();
        // $data_perusahaan = Sub_Divisi::where('divisi_id', '1')->first();

        // $id_perusahaan = $data_perusahaan->divisi->perusahaan->id;
        // $id_divisi = $data_perusahaan->divisi_id;
        // $id_sub_divisi = $data_perusahaan->id;
        
        if ($request->ajax()) {
            // $sub_divisi = Sub_Divisi::where('kode_sub_divisi', $id)->first();
            $data_data = Gs_Barangs::orderBy('id', 'DESC')->get();
            // $data = Gs_Barangs::where('perusahaan_id', $id_perusahaan)
            // ->where('divisi_id', $id_divisi)
            // ->where('sub_divisi_id', $id_sub_divisi)
            // ->where('proyek_id', $data_proyek->id)->orderBy('kode_barang', 'asc');
          
            return DataTables::of($data_data)
                ->addIndexColumn()
                ->addColumn('stokawal', function ($row) {
                    $result = '<div class=""> <p class=fs-6> '.$row->kode_barang.' </p></div>';
                    // $result = '<a href="example.com/member/">'.$row->kode_barang.'</a>';

                    
                    return $result;
                })
                ->addColumn('jmlmasuk', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    } else {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }

                    $result = '<span class="">'.$jmlmasuk.'</span>';

                    return $result;
       
                })
                ->addColumn('jmlkeluar', function ($row) use ($request) {
                    if ($request->tglawal) {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    }

                    $result = '<span class="">'.$jmlkeluar.'</span>';

                    return $result;        
                })
                ->addColumn('totalstok', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    } else {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                        // $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }


                    if ($request->tglawal) {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                        // $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    }

                    $totalstok = $jmlmasuk - $jmlkeluar;
                    if($totalstok == 0){
                        $result = '<span class="">'.$totalstok.'</span>';
                    }else if($totalstok > 0){
                        $result = '<span class="text-success">'.$totalstok.'</span>';
                    }else{
                        $result = '<span class="text-danger">'.$totalstok.'</span>';
                    }
                    

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    // $result = '<span class="badge badge-success text-primary"> '.$row->id.'</span>';
                    $result = '<div class=""><a class="badge-edit text-light text-decoration-none" href="/sa_master_konstruksi_stok_barang/show/'.$row->kode_barang.'">Detail</a></div>';
                    
                    return $result;
                })
                ->rawColumns(['stokawal', 'jmlmasuk', 'jmlkeluar', 'totalstok', 'opsi'])->make(true);
        }
    }

    public function print(Request $request, $proyek,  $sub_divisi, )
    {
        $data_proyek = Proyek::where('nama_proyek', $proyek)->first();
        $data_perusahaan = Sub_Divisi::where('divisi_id', $sub_divisi)->first();

        $id_perusahaan = $data_perusahaan->divisi->perusahaan->id;
        $id_divisi = $data_perusahaan->divisi_id;
        $id_sub_divisi = $data_perusahaan->id;

       
            $data['data'] = Gs_Barangs::where('perusahaan_id', $id_perusahaan)
            ->where('divisi_id', $id_divisi)
            ->where('sub_divisi_id', $id_sub_divisi)
            ->where('proyek_id', $data_proyek->id)->orderBy('kode_barang', 'asc')->get();

        $data["title"] = "Print Barang Masuk";
        $data['web'] = Gs_Barangs::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.perusahaan.barang.print', $data);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
