<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Kendaraan;

use App\Http\Controllers\Controller;
use App\Models\Kendaraan\Kendaraan_Out;
use App\Models\Kendaraan\Pajak;
use App\Models\Kendaraan\Pajak_Riwayat;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Kendaraan_Pajak_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //

        $data_data = Sub_Divisi::where('id', $id)->first();

        // $data = Consumable_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        $pajak = Pajak::where('sub_divisi_id', $id)->where('pembayaran_pajak', '<=', Carbon::now())->count('pembayaran_pajak');
        $stnk = Pajak::where('sub_divisi_id', $id)->where('pembayaran_stnk', '<=', Carbon::now())->count('pembayaran_stnk');

        return view('superadmin.perusahaan.kendaraan.pajak.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            'pajak' => $pajak,
            'stnk' => $stnk,
            // 'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
             
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Pajak::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Pajak::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('tanggal', function ($row) {
                    $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                    return $result;
                })
                ->addColumn('tanggal_pajak', function ($row) {
                    $tanggal_pajak = $row->pembayaran_pajak == '' ? '-' : Carbon::parse($row->pembayaran_pajak)->translatedFormat('d-m-Y');

                    $date1 = Carbon::now();

                    $date2 = $row->pembayaran_pajak == '' ? '-' : Carbon::parse($row->pembayaran_pajak);

                    $hari = $date1->diffInDays($date2);


                    // $hari= calculateDaysDifference($mytime, $servis_next) ;
                    if ($date1 >= $date2) {
                        # code...
                        $result = '<a href="/superadmin_pajak/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold text-danger">' . $tanggal_pajak . ' ( Lewat ' . $hari . ' Hari) </a>';
                    } else {
                        # code...
                        $result = '<a href="/superadmin_pajak/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold text-primary">' . $tanggal_pajak . ' (Sisa ' . $hari . ' Hari)</a>';
                    }

                    return $result;
                })
                ->addColumn('ganti_plat', function ($row) {
                    $ganti_plat = $row->pembayaran_stnk == '' ? '-' : Carbon::parse($row->pembayaran_stnk)->translatedFormat('d-m-Y');

                    $date1 = Carbon::now();

                    $date2 = $row->pembayaran_stnk == '' ? '-' : Carbon::parse($row->pembayaran_stnk);

                    $hari = $date1->diffInDays($date2);


                    // $hari= calculateDaysDifference($mytime, $servis_next) ;
                    if ($date1 >= $date2) {
                        # code...
                        $result = '<a href="/superadmin_pajak/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold text-danger">' . $ganti_plat . '( Lewat ' . $hari . ' Hari) </a>';
                    } else {
                        # code...
                        $result = '<a href="/superadmin_pajak/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold text-primary">' . $ganti_plat . ' (Sisa ' . $hari . ' Hari)</a>';
                    }

                    return $result;
                })
                ->addColumn('kendaraan', function ($row) {
                    $kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->kode_kendaraan;

                    $result = '<a href="/superadmin_pajak/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$kendaraan.'</a>';

                    return $result;
                })
                ->addColumn('nomor', function ($row) {
                    $nomor =  $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->no_aset;

                    $result = '<a href="/superadmin_pajak/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$nomor.'</a>';

                    return $result;
                })
                ->addColumn('nopol', function ($row) {
                    $nopol = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->kendaraan_in->nopol;

                    $result = '<div  class="fs_tabel ">'.$nopol.'</div>';

                    return $result;
                })
                ->addColumn('nama_kendaraan', function ($row) {
                    $nama_kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->nama_kendaraan;

                    $result = '<div  class="fs_tabel ">'.$nama_kendaraan.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->merek;

                    $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                    return $result;
                })
               
                ->addColumn('warna', function ($row) {
                    $warna = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->kendaraan_in->warna;

                    $result = '<div  class="fs_tabel ">'.$warna.'</div>';

                    return $result;
                })
                ->addColumn('penerima', function ($row) {
                    $penerima = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->penerima;

                    $result = '<div  class="fs_tabel ">'.$penerima.'</div>';

                    return $result;
                })
                ->addColumn('nik', function ($row) {
                    $nik = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->nik;

                    $result = '<div  class="fs_tabel ">'.$nik.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->n_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('pemakai', function ($row) {
                    $pemakai = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->pemakai;

                    $result = '<div  class="fs_tabel ">'.$pemakai.'</div>';

                    return $result;
                })
                ->addColumn('lokasi', function ($row) {
                    $lokasi = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->lokasi;

                    $result = '<div  class="fs_tabel ">'.$lokasi.'</div>';

                    return $result;
                })
                ->addColumn('aset', function ($row) {
                    $aset =  $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->kendaraan_in->aset;

                    $result = '<div  class="fs_tabel  ">'.$aset.'</div>';

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/superadmin_pajak/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/superadmin_pajak/delete/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal_pajak', 
                    'ganti_plat', 
                    'tanggal', 
                    'kendaraan', 
                    'nomor', 
                    'nopol', 
                    'nama_kendaraan', 
                    'merek', 
                    'warna', 
                    'penerima', 
                    'nik', 
                    'divisi', 
                    'pemakai', 
                    'lokasi', 
                    'aset', 
                    'opsi',
                    ])->make(true);
        }
    }


    public function cari_barang($id)
    {

        // dd($id);
        // $data = Gs_Barangs::orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Kendaraan_Out::where('sub_divisi_id', $id)->orderBy('no_aset', 'asc');
        // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('no_aset', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('penerima', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.perusahaan.kendaraan.pajak.barang', [
            'data_data' => $data_data,
            'data' => $data->paginate(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $notif['kendaraan_out_id'] = [
            'required' => 'Kendaraan sudah ada',
        ];

        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kendaraan_id' => 'required',
            'kendaraan_out_id' => 'required|unique:pajaks',
            'pembayaran_pajak' => 'required',
            'pembayaran_stnk' => 'required',
            'kir' => 'required',
            'keterangan' => 'required',

        ], $notif);

        // dd($data);
        Pajak::create($data);
        return redirect('/superadmin_pajak/pajak/'.$id)->with('toast_success', 'Data Ditambahkan !');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        $riwayat = Pajak_riwayat::where('pajak_id', $id)->orderBy('id', 'desc');

        return view('superadmin.perusahaan.kendaraan.pajak.view', [
            'data_data' => Pajak::find($id),
            'riwayat' => $riwayat->paginate(10),

            // 'perusahaan' => Perusahaan::all(),
            // 'riwayat' =>  $riwayat->paginate(10),
  


            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            'pembayaran_pajak' => 'required',
            'pembayaran_stnk' => 'required',
            'kir' => 'required',
            'keterangan' => 'required',
        ]);

        $data2 = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kendaraan_id' => 'required',
            'kendaraan_out_id' => 'required',
            'pajak_id' => 'required',
            'tanggal_pembayaran' => 'required',
            'pembayaran_pajak' => 'required',
            'pembayaran_stnk' => 'required',
            'kir' => 'required',
            'keterangan' => 'required',
        ]);

        // dd($data, $data2);
        Pajak_Riwayat::create($data2);
        Pajak::where('id', $id)->update($data);
        return back()->with('toast_success', 'Data Tersimpan !!');
        // return redirect('/superadmin_inventaris/perawatan/' . $it)->with('toast_success', 'Data di Update !');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        
        Pajak::destroy($id);
        Pajak_Riwayat::where('pajak_id','=', $id)->delete();
        return back()->with('toast_success', 'Data Di Hapus !!');
    }
}
