<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Kendaraan;

use App\Http\Controllers\Controller;
use App\Models\Kategori;
use App\Models\Kendaraan\Kendaraan;
use App\Models\Kendaraan\Kendaraan_In;
use App\Models\Kendaraan\Kendaraan_Out;
use App\Models\Kendaraan\Pajak;
use App\Models\Kendaraan\Pajak_Riwayat;
use App\Models\Kendaraan\Servis;
use App\Models\Kendaraan\Servis_riwayat;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;

class Superadmin_Data_Kendaraan_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Kendaraan::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        if (request('search')) {
            $data->where('kode_motor', 'like', '%' . request('search') . '%')
            ->orWhere('nama_motor', 'like', '%' . request('search') . '%')
            ->orWhere('merek', 'like', '%' . request('search') . '%');
        }

        return view('superadmin.perusahaan.kendaraan.kendaraan.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        return view('superadmin.perusahaan.kendaraan.kendaraan.add', [
            'data_data' =>  $data_data,
            'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_kendaraan' => 'required|unique:kendaraans',
            'nama_kendaraan' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Kendaraan::create($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/superadmin_kendaraan/kendaraan/index/'.$id)->with('toast_success', 'Data Kendaraan Ditambahkan');
     
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        $data = Kendaraan::where('kode_kendaraan', $id)->first();

        return view('superadmin.perusahaan.kendaraan.kendaraan.edit', [
            // 'data_data' =>  $data_data,
            'data' => $data,
            'kategori' =>  Kategori::all()
            
        ]);
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_kendaraan' => 'required',
            'nama_kendaraan' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Kendaraan::where('id', $id)->update($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/superadmin_kendaraan/kendaraan/index/'.$it)->with('toast_success', 'Data Barang Di Update');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Kendaraan::destroy($id);
        Kendaraan_In::where('kendaraan_id','=', $id)->delete();
        Kendaraan_Out::where('kendaraan_id','=', $id)->delete();
        Servis::where('kendaraan_id','=', $id)->delete();
        Servis_riwayat::where('kendaraan_id','=', $id)->delete();
        Pajak::where('kendaraan_id','=', $id)->delete();
        Pajak_Riwayat::where('kendaraan_id','=', $id)->delete();
        // Inventaris_Out::where('inventaris_id','=', $id)->delete();
        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
