<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Consumable;

use App\Http\Controllers\Controller;
use App\Models\Consumable\Consumable;
use App\Models\Consumable\Consumable_In;
use App\Models\Consumable\Consumable_Out;
use App\Models\Gs\Gs_Barangs;
use App\Models\Gs\Gs_In_Barang;
use App\Models\Gs\Gs_Out_Barang;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Consumable_Controller extends Controller
{
    //
    public function index($id)
    {
        $data_data = Sub_Divisi::where('id', $id)->first();

        $jumlah_barang = Consumable::where('sub_divisi_id', $id)->count('id');
        $jumlah_masuk = Consumable_In::where('sub_divisi_id', $id)->count('id');
        $jumlah_keluar = Consumable_Out::where('sub_divisi_id', $id)->count('id');

        return view('superadmin.perusahaan.consumable.index', [
            'data_data' => $data_data,
            'id' => $id,
            'jumlah_barang' => $jumlah_barang,
            'jumlah_masuk' => $jumlah_masuk,
            'jumlah_keluar' => $jumlah_keluar,


            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    public function get_data(Request $request, $id)
    {
        // $data_proyek = Proyek::where('id', $id)->first();
        // $data_perusahaan = Sub_Divisi::where('divisi_id', '1')->first();

        // $id_perusahaan = $data_perusahaan->divisi->perusahaan->id;
        // $id_divisi = $data_perusahaan->divisi_id;
        // $id_sub_divisi = $data_perusahaan->id;

        if ($request->ajax()) {
            // $sub_divisi = Sub_Divisi::where('kode_sub_divisi', $id)->first();
            // $data = Consumable::orderBy('id', 'DESC')->get();
            $data = Consumable::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc')->get();
            // ->where('sub_divisi_id', $id_sub_divisi)
            // ->where('proyek_id', $data_proyek->id)->orderBy('kode_barang', 'asc');

            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('stokawal', function ($row) {
                    $result = '<div class=""> <p class=fs-6> ' . $row->kode_barang . ' </p></div>';
                    // $result = '<a href="example.com/member/">'.$row->kode_barang.'</a>';

                    return $result;
                })
                ->addColumn('kode', function ($row) {
                    $result = '<a href="/superadmin_consumable/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="text-decoration-none fw-bold " style="font-size: 14px">'.$row->kode_barang.'</a>';

                    return $result;
                })
                ->addColumn('jmlmasuk', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Consumable_In::leftJoin('consumables', 'consumables.id', '=', 'consumable__ins.consumable_id')
                            ->where('consumable__ins.consumable_id', '=', $row->id)
                            ->sum('consumable__ins.jumlah');
                    } else {
                        $jmlmasuk = Consumable_In::leftJoin('consumables', 'consumables.id', '=', 'consumable__ins.consumable_id')
                            ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                            ->where('consumable__ins.consumable_id', '=', $row->id)
                            ->sum('consumable__ins.jumlah');
                    }

                    $result = '<span class="">' . $jmlmasuk . '</span>';

                    return $result;
                })
                ->addColumn('jmlkeluar', function ($row) use ($request) {
                    if ($request->tglawal) {
                        $jmlkeluar = Consumable_Out::leftJoin('consumables', 'consumables.id', '=', 'consumable__outs.consumable_id')
                            ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                            ->where('consumable__outs.consumable_id', '=', $row->id)
                            ->sum('consumable__outs.jumlah');
                    } else {
                        $jmlkeluar = Consumable_Out::leftJoin('consumables', 'consumables.id', '=', 'consumable__outs.consumable_id')
                            ->where('consumable__outs.consumable_id', '=', $row->id)
                            ->sum('consumable__outs.jumlah');
                    }

                    $result = '<span class="">' . $jmlkeluar . '</span>';

                    return $result;
                })
                ->addColumn('totalstok', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Consumable_In::leftJoin('consumables', 'consumables.id', '=', 'consumable__ins.consumable_id')
                            ->where('consumable__ins.consumable_id', '=', $row->id)
                            ->sum('consumable__ins.jumlah');
                    } else {
                        $jmlmasuk = Consumable_In::leftJoin('consumables', 'consumables.id', '=', 'consumable__ins.consumable_id')
                            ->where('consumable__ins.consumable_id', '=', $row->id)
                            ->sum('consumable__ins.jumlah');
                        // $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }

                    if ($request->tglawal) {
                        $jmlkeluar = Consumable_Out::leftJoin('consumables', 'consumables.id', '=', 'consumable__outs.consumable_id')
                            ->where('consumable__outs.consumable_id', '=', $row->id)
                            ->sum('consumable__outs.jumlah');
                        // $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Consumable_Out::leftJoin('consumables', 'consumables.id', '=', 'consumable__outs.consumable_id')
                            ->where('consumable__outs.consumable_id', '=', $row->id)
                            ->sum('consumable__outs.jumlah');
                    }

                    $totalstok = $jmlmasuk - $jmlkeluar;
                    if ($totalstok == 0) {
                        $result = '<span class="">' . $totalstok . '</span>';
                    } elseif ($totalstok > 0) {
                        $result = '<span class="text-success">' . $totalstok . '</span>';
                    } else {
                        $result = '<span class="text-danger">' . $totalstok . '</span>';
                    }

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    // $result = '<span class="badge badge-success text-primary"> '.$row->id.'</span>';
                    $result = '<div class=""><a class="badge-edit text-light text-decoration-none" href="/superadmin_consumable/show/' . $row->id . '/' . $row->sub_divisi_id . '">Detail</a></div>';

                    return $result;
                })
                ->rawColumns(['kode','stokawal', 'jmlmasuk', 'jmlkeluar', 'totalstok', 'opsi'])
                ->make(true);
        }
    }

    public function print(Request $request, $id)
    {
        $data['data'] = Consumable::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc')->get();

        $item = Sub_Divisi::where('id', $id)->first();

        $data['title'] = 'Print Barang Masuk';
        $data['web'] = Consumable::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.perusahaan.consumable.print', $data, [
            'item' => $item
        ]);
    }

    public function show(string $id, $it)
    {
        //
        $data_data = Sub_Divisi::where('id', $it)->first();
        $barang = Consumable::where('id', $id )->first();

        // dd($barang);

        $in_barang = Consumable_In::where('consumable_id', $barang->id)->orderBy('id', 'desc');
        $out_barang = Consumable_Out::where('consumable_id', $barang->id)->orderBy('id', 'desc');
        
        $masuk = Consumable_In::where('consumable_id', $barang->id)->sum('jumlah');
        $keluar = Consumable_Out::where('consumable_id', $barang->id)->sum('jumlah');

        return view('superadmin.perusahaan.consumable.show', [
            'data_data' => $data_data,
        //   'data' => $data,
            'barang' => $barang,
            'in_barang' => $in_barang->paginate(10),
            'out_barang' => $out_barang->paginate(10),
            'masuk' => $masuk,
            'keluar' => $keluar


        ]);
    }

    public function gambar($id)
    {
        return view('superadmin.perusahaan.view_gambar', [
           
            'item' => Consumable_In::find($id),
        ]);
    }
}
