<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Consumable;

use App\Http\Controllers\Controller;
use App\Models\Consumable\Consumable;
use App\Models\Consumable\Consumable_In;
use App\Models\Consumable\Consumable_Out;
use App\Models\Gs\Gs_Barangs;
use App\Models\Kategori;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;

class Superadmin_Consumable_Barang_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Consumable::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        if (request('search')) {
            $data->where('kode_barang', 'like', '%' . request('search') . '%')
            ->orWhere('nama_barang', 'like', '%' . request('search') . '%')
            ->orWhere('merek', 'like', '%' . request('search') . '%');
        }

        return view('superadmin.perusahaan.consumable.barang.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        return view('superadmin.perusahaan.consumable.barang.add', [
            'data_data' =>  $data_data,
            'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_barang' => 'required|unique:consumables',
            'nama_barang' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Consumable::create($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/superadmin_consumable/consumable/barang/'.$id)->with('toast_success', 'Data Barang DItambahkan');
        // return redirect()->to('job_view/'.$id);;
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        // $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Consumable::where('kode_barang', $id)->first();

        return view('superadmin.perusahaan.consumable.barang.edit', [
            // 'data_data' =>  $data_data,
            'data' => $data,
            'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_barang' => 'required',
            'nama_barang' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Consumable::where('id', $id)->update($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/superadmin_consumable/consumable/barang/'.$it)->with('toast_success', 'Data Barang Di Update');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id, $it)
    {
        //
        Consumable::destroy($id);
        Consumable_In::where('consumable_id','=', $id)->delete();
        Consumable_Out::where('consumable_id','=', $id)->delete();
        return redirect('/superadmin_consumable/consumable/barang/'.$it)->with('toast_success', 'Data Barang Di Hapus');

    }
}
