<?php

namespace App\Http\Controllers\Superadmin\Gs\Produksi\Consumable;

use App\Http\Controllers\Controller;
use App\Models\Gs\Gs_Barangs;
use App\Models\Gs\Gs_Out_Barang;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Gs_Produksi_Out_Barang_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Gs_Out_Barang::orderBy('id', 'asc');

        if (request('search')) {
            $data->where('gs_barang_id', 'like', '%' . request('search') . '%')
            ->orWhere('satuan', 'like', '%' . request('search') . '%');
        }
        

        return view('superadmin.gs.produksi.consumable.gs_out_barang.index', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Keluar',
            'data' => $data->paginate(),


            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }


    public function show_data(Request $request) 
    {
        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Gs_Out_Barang::where('perusahaan_id', '1')->first()->where('proyek_id', '2')->orderBy('id', 'DESC')->get();
            } else {
                $data = Gs_Out_Barang::where('perusahaan_id', '1')->first()->where('proyek_id', '2')->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('tanggal', function ($row) {
                    $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                    return $result;
                })
                ->addColumn('barang', function ($row) {
                    $barang = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->kode_barang;

                    $result = '<a href="/sa_master_produksi_out_barang/'.$row->id.'" class="fs_tabel fw-bold ">'.$barang.'</a>';

                    return $result;
                })
                ->addColumn('nama_barang', function ($row) {
                    $n_barang = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->nama_barang;

                    $result = '<div  class="fs_tabel ">'.$n_barang.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->merek;

                    $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                    return $result;
                })
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                    return $result;
                })
                ->addColumn('nama_divisi', function ($row) {
                    $nama_divisi = $row->n_divisi == '' ? '-' :  $row->divisi->nama_divisi;

                    $result = '<div  class="fs_tabel ">'.$nama_divisi.'</div>';

                    return $result;
                })
                ->addColumn('sub_divisi', function ($row) {
                    $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                    $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                    return $result;
                })
                ->addColumn('proyek', function ($row) {
                    $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                    $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->nama_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('perusahaan', function ($row) {
                    $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                    $result = '<div  class="fs_tabel ">'.$perusahaan.'</div>';

                    return $result;
                })
                ->addColumn('created_at', function ($row) {
                    $tanggal_input = $row->created_at == '' ? '-' : Carbon::parse($row->creted_at)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal_input.'</div>';

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/sa_master_produksi_out_barang/'.$row->id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/sa_master_produksi_out_barang/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'barang', 
                    'nama_barang', 
                    'merek', 
                    'kategori', 
                    'nama_divisi', 
                    'sub_divisi', 
                    'proyek',
                    'divisi',
                    'perusahaan',
                    'created_at',
                    'gambar',
                    'opsi',
                    ])->make(true);
        }
    }

    public function print($id, Request $request)
    {
        if ($request->tglawal) {
            $data['data'] = Gs_Out_Barang::where('perusahaan_id', '1')->first()->where('proyek_id', '2')->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();;
        } else {
            $data['data'] = Gs_Out_Barang::orderBy('id', 'DESC')->get();
        }

        $data["title"] = "Print Barang Masuk";
        $data['web'] = Gs_Out_Barang::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.gs.produksi.consumable.gs_out_barang.print', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $perusahaan = Gs_Barangs::where('perusahaan_id', '1')->first();
        $data = $perusahaan->where('proyek_id', '2')->orderBy('kode_barang', 'asc');

        if (request('cari_barang')) {
            $data->where('kode_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('nama_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('merek', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.gs.produksi.consumable.gs_out_barang.barang', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Keluar / Cari Barang',
            'data' => $data->paginate(),
        ]);
    }

    public function add_barang($id)
    {
        // $data = Gs_Barangs::orderBy('id', 'asc');

        $data = Gs_Barangs::where('kode_barang', $id)->first();

        return view('superadmin.gs.produksi.consumable.gs_out_barang.add', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Keluar',
            // 'data' => $data->paginate(1),
            'item' => $data,
            'divisi' => Divisi::all(),
            'perusahaan' => Perusahaan::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'gs_barang_id' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'nama' => 'required',
            'n_divisi' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'status' => 'required',
            'keterangan' => 'required',
        ]);

        // dd($data);
        Gs_Out_Barang::create($data);
        return redirect('sa_master_produksi_out_barang')->with('toast_success', 'Data Ditambahkan !');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        // $data = Gs_Barangs::orderBy('id', 'asc');

        // if (request('cari_barang')) {
        //     $data->where('kode_barang', 'like', '%' . request('cari_barang') . '%')
        //     ->orWhere('nama_barang', 'like', '%' . request('cari_barang') . '%')
        //     ->orWhere('merek', 'like', '%' . request('cari_barang') . '%');
        // }
        return view('superadmin.gs.produksi.consumable.gs_out_barang.edit', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Keluar',
            // 'data' => $data->paginate(1),
            'item' => Gs_Out_Barang::find($id),
            'divisi' => Divisi::all(),
            'perusahaan' => Perusahaan::all()
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            // 'gs_barang_id' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'nama' => 'required',
            'n_divisi' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'status' => 'required',
            'keterangan' => 'required',
        ]);

        // dd($data);
        Gs_Out_Barang::where('id', $id)->update($data);
        return redirect('sa_master_produksi_out_barang')->with('toast_success', 'Data di Update !');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Gs_Out_Barang::destroy($id);
        return redirect('sa_master_produksi_out_barang')->with('toast_success', 'Data di Hapus !');

    }
}
