<?php

namespace App\Http\Controllers\Superadmin\Gs\Konstruksi\Consumable;

use App\Http\Controllers\Controller;
use App\Models\Gs\Gs_Barangs;
use App\Models\Gs\Gs_In_Barang;
use App\Models\Gs\Gs_Out_Barang;
use App\Models\Kategori;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;

class Superadmin_Gs_Konstruksi_Barang_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
            # code...
            $perusahaan = Gs_Barangs::where('perusahaan_id', '1')->first();
            if ($perusahaan) {
                $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
                # code...
            } 
            


        if (request('search')) {
            $data->where('kode_barang', 'like', '%' . request('search') . '%')
            ->orWhere('nama_barang', 'like', '%' . request('search') . '%')
            ->orWhere('merek', 'like', '%' . request('search') . '%');
        }

     

        if ($perusahaan) {
            return view('superadmin.gs.konstruksi.consumable.gs_barang.index', [
                'menu' => 'BMS',
                'nama_menu' => 'General Support',
                'kategori_menu' => 'Data Barang',
                'data' => $data->paginate(),
                // 'proyek' => Proyek::all(),
    
    
                $title = 'Hapus Data',
                $text = "Apakah anda yakin ingin menghapus?",
                confirmDelete($title, $text),
            ]);
        } else {
            return view('superadmin.gs.konstruksi.consumable.gs_barang.add', [
                'menu' => 'BMS',
                'nama_menu' => 'General Support',
                'kategori_menu' => 'Data Barang',
                'perusahaan' => Perusahaan::all(),
                'kategori' => Kategori::all(),
                'proyek' => Proyek::all()
            ]);
        }
        

       
        

       
    }


    // public function proyek($id) 
    // {
    //     $proyek = Proyek::where('nama_proyek', $id)->first();

    //     $data = Gs_Barangs::where('proyek_id', $proyek->id)->orderBy('kode_barang', 'asc');

    //     if (request('search')) {
    //         $data->where('kode_barang', 'like', '%' . request('search') . '%')
    //         ->orWhere('nama_barang', 'like', '%' . request('search') . '%')
    //         ->orWhere('merek', 'like', '%' . request('search') . '%');
    //     }

    //     return view('superadmin.gs.gs_barang.show', [
    //         'menu' => 'BMS',
    //         'nama_menu' => 'General Support',
    //         'kategori_menu' => 'Data Barang',
    //         'data' => $data->paginate(),
    //         'proyek' => $proyek,


    //         $title = 'Hapus Data',
    //         $text = "Apakah anda yakin ingin menghapus?",
    //         confirmDelete($title, $text),
    //     ]);
    // }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('superadmin.gs.konstruksi.consumable.gs_barang.add', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Data Barang',
            'perusahaan' => Perusahaan::all(),
            'kategori' => Kategori::all(),
            'proyek' => Proyek::all()
        ]);
    }

    public function getdivisi(Request $request)
    {
        $id_perusahaan = $request->id_perusahaan;

        $divisi = Divisi::where('perusahaan_id', $id_perusahaan)->get();

        foreach ($divisi as $item) {
            echo "<option value='$item->id'>$item->nama_divisi</option>";
        }
    }
    public function getsubdivisi(Request $request)
    {
        $id_divisi = $request->id_divisi;

        $subdivisi = Sub_Divisi::where('divisi_id', $id_divisi)->get();

        foreach ($subdivisi as $item) {
            echo "<option value='$item->id'>$item->nama_sub_divisi</option>";
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_barang' => 'required|unique:gs__barangs',
            'nama_barang' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Gs_Barangs::create($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('sa_master_gs_konstruksi_barang')->with('toast_success', 'Data Barang DItambahkan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('superadmin.gs.konstruksi.consumable.gs_barang.edit', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Data Barang',
            'data' => Gs_Barangs::find($id),
            'perusahaan' => Perusahaan::all(),
            'proyek' => Proyek::all(),
            'kategori' => Kategori::all(),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'kategori_id' => 'required',
            'proyek_id' => 'required',
            'kode_barang' => 'required',
            'nama_barang' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Gs_Barangs::where('id', $id)->update($data);
        return redirect('sa_master_gs_konstruksi_barang')->with('toast_success', 'Data Barang di Update ');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Gs_Barangs::destroy($id);
        Gs_In_Barang::where('gs_barang_id','=', $id)->delete();
        Gs_Out_Barang::where('gs_barang_id','=', $id)->delete();
        // Alert::success('Hore!', 'Post Created Successfully');
        return redirect('sa_master_gs_konstruksi_barang')->with('toast_success', 'Data Barang di Hapus !');

    }
}
