<?php

namespace App\Http\Controllers\Admin_Area\Kendaraan;

use App\Http\Controllers\Controller;
use App\Models\Kendaraan\Kendaraan;
use App\Models\Kendaraan\Kendaraan_In;
use App\Models\Kendaraan\Kendaraan_Out;
use App\Models\Kendaraan\Pajak;
use App\Models\Kendaraan\Pajak_Riwayat;
use App\Models\Kendaraan\Servis;
use App\Models\Kendaraan\Servis_riwayat;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class Kendaraan_In_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        // //
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Kendaraan_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        // if (request('search')) {
        //     $data->where('kode_barang', 'like', '%' . request('search') . '%')
        //     ->orWhere('nama_barang', 'like', '%' . request('search') . '%')
        //     ->orWhere('merek', 'like', '%' . request('search') . '%');
        // }

        return view('admin_area.menu.kendaraan.masuk.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
             
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Kendaraan_In::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Kendaraan_In::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('tanggal', function ($row) {
                    $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                    return $result;
                })
                ->addColumn('kendaraan', function ($row) {
                    $kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->kode_kendaraan;

                    $result = '<a href="/superadmin_kendaraan/show_barang_masuk/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$kendaraan.'</a>';

                    return $result;
                })
                ->addColumn('nama_kendaraan', function ($row) {
                    $nama_kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->nama_kendaraan;

                    $result = '<div  class="fs_tabel ">'.$nama_kendaraan.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->merek;

                    $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                    return $result;
                })
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                    return $result;
                })
                ->addColumn('sub_divisi', function ($row) {
                    $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                    $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                    return $result;
                })
                ->addColumn('proyek', function ($row) {
                    $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                    $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->kode_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('perusahaan', function ($row) {
                    $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                    $result = '<div  class="fs_tabel ">'.$perusahaan.'</div>';

                    return $result;
                })
                ->addColumn('created_at', function ($row) {
                    $tanggal_input = $row->created_at == '' ? '-' : Carbon::parse($row->creted_at)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal_input.'</div>';

                    return $result;
                })
                ->addColumn('gambar', function ($row) {
                    $result = '<a target="_blank" rel="noopener noreferrer" href="/kendaraan/view_gambar/'.$row->id.'"  class="text-center "><i class="bi bi-card-image"></i></a>';

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/superadmin_kendaraan/show_barang_masuk/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/superadmin_kendaraan/kendaraan/masuk/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'kendaraan', 
                    'nama_kendaraan', 
                    'merek', 
                    'kategori', 
                    'sub_divisi', 
                    'proyek',
                    'divisi',
                    'perusahaan',
                    'created_at',
                    'gambar',
                    'opsi',
                    ])->make(true);
        }
    }

    public function print(Request $request, $id)
    {

        // dd($id);
        if ($request->tglawal) {
            $data['data'] = Kendaraan_In::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();;
        } else {
            $data['data'] = Kendaraan_In::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
        }

        $item = Sub_Divisi::where('id', $id)->first();

        $data["title"] = "Print Barang Masuk";
        $data['web'] = Kendaraan_In::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('admin_area.menu.kendaraan.masuk.print', $data, [
            'item' => $item
        ]);
    }

  


    public function cari_barang($id)
    {

        // dd($id);
        // $data = Gs_Barangs::orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Kendaraan::where('sub_divisi_id', $id)->orderBy('kode_kendaraan', 'asc');
        // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('kode_kendaraan', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('nama_kendaraan', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('merek', 'like', '%' . request('cari_barang') . '%');
        }
        return view('admin_area.menu.kendaraan.masuk.barang', [
            'data_data' => $data_data,
            'data' => $data->paginate(),
        ]);
    }

    public function gambar($id)
    {
        return view('admin_area.menu.view_gambar', [
           
            'item' => Kendaraan_In::find($id),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $data_data = Kendaraan::where('kode_kendaraan', $id)->first();

        return view('admin_area.menu.kendaraan.masuk.add', [
            'data_data' =>  $data_data,
            'perusahaan' =>  Perusahaan::all()
            
        ]);
    }

    public function data_barang($id) 
    {
 
         $data = Kendaraan::where('sub_divisi_id', $id)->orderBy('kode_kendaraan', 'asc');
 
         return view('admin_area.menu.kendaraan.masuk.data_barang')->with([
             'data' => $data->paginate(15)
         ]);
    }
 
    public function search(Request $request, $id) 
    {
         $barang = $request->barang;
         $result = Kendaraan::where('sub_divisi_id', $id)->where('kode_kendaraan', 'like', '%'.$barang.'%', )->orwhere('sub_divisi_id', $id)->where('nama_kendaraan', 'like', '%'.$barang.'%', )->orwhere('sub_divisi_id', $id)->where('merek', 'like', '%'.$barang.'%', )->get();
         // $result = Consumable::where('sub_divisi_id', $id)->where('nama_barang', 'like', '%'.$barang.'%' )->get();
         // $result = Consumable::where('sub_divisi_id', $id)->where('merek', 'like', '%'.$barang.'%' )->get();
 
         $data = count($result);
         
         if($data == 0) {
             return '<p class="text-center"><i class="bi bi-search"></i> Opps !!! Kendaraan Tidak ditemukan...</p>';
         }else{
             return view('admin_area.menu.kendaraan.masuk.data_barang')->with([
                 'data' => $result
             ]);
         }
 
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kendaraan_id' => 'required',
            'aset' => 'required',
            'nopol' => 'required|unique:kendaraan__ins',
            'warna' => 'required',
            'tahun' => 'required',
            'no_rangka' => 'required|unique:kendaraan__ins',
            'no_mesin' => 'required|unique:kendaraan__ins',
            'plat' => 'required',
            'stnk' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'suplayer' => 'required',
            'tanggal' => 'required',
            'lokasi' => 'required',
            'keterangan' => 'required',
            'image' => 'required|image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);

        if($request->file('image')) {
            // $data['image'] = $request->file('image')->store('post-image');
            $data['image'] = $request->file('image')->store('image', 'public');
        }

        // dd($data);


        Kendaraan_In::create($data);
        return redirect('/kendaraan/kendaraan/masuk/'.$id)->with('toast_success', 'Data Barang DItambahkan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('admin_area.menu.kendaraan.masuk.edit', [
            'data_data' =>  Kendaraan_In::find($id),
            'perusahaan' =>  Perusahaan::all()
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            // 'kendaraan_id' => 'required',
            'aset' => 'required',
            'nopol' => 'required',
            'warna' => 'required',
            'tahun' => 'required',
            'no_rangka' => 'required',
            'no_mesin' => 'required',
            'plat' => 'required',
            'stnk' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'suplayer' => 'required',
            'tanggal' => 'required',
            'lokasi' => 'required',
            'keterangan' => 'required',
            'image' => 'image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);

        if($request->file('image')) {
            if($request->imagelama) {
                Storage::delete($request->imagelama);
            }
                // Storage::delete($request->gambarlama);

            // $data['image'] = $request->file('image')->store('post-image');
            $data['image'] = $request->file('image')->store('image');
        }

        // dd($data);
        Kendaraan_In::where('id', $id)->update($data);
        return redirect('/kendaraan/kendaraan/masuk/'.$it)->with('toast_success', 'Data Kendaraan di Update ');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        $hapus =  Kendaraan_Out::where('kendaraan_in_id', $id)->first();

        Kendaraan_In::destroy($id);
        Kendaraan_Out::where('kendaraan_in_id','=', $id)->delete();
        Servis::where('kendaraan_out_id','=', $hapus->id)->delete();
        Servis_riwayat::where('kendaraan_out_id','=', $hapus->id)->delete();
        Pajak::where('kendaraan_out_id','=', $hapus->id)->delete();
        Pajak_Riwayat::where('kendaraan_out_id','=', $hapus->id)->delete();

        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
