<?php

namespace App\Http\Controllers\Admin_Area\Inventaris;

use App\Http\Controllers\Controller;
use App\Models\Inventaris\Inventaris;
use App\Models\Inventaris\Inventaris_In;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class Inventaris_In_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Inventaris_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        // if (request('search')) {
        //     $data->where('kode_barang', 'like', '%' . request('search') . '%')
        //     ->orWhere('nama_barang', 'like', '%' . request('search') . '%')
        //     ->orWhere('merek', 'like', '%' . request('search') . '%');
        // }

        return view('admin_area.menu.inventaris.masuk.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
             
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Inventaris_In::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Inventaris_In::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('tanggal', function ($row) {
                    $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                    return $result;
                })
                ->addColumn('barang', function ($row) {
                    $barang = $row->inventaris_id == '' ? '-' :  $row->inventaris->kode_barang;

                    $result = '<a href="/inventaris/show_barang_masuk/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$barang.'</a>';

                    return $result;
                })
                ->addColumn('nama_barang', function ($row) {
                    $n_barang = $row->inventaris_id == '' ? '-' :  $row->inventaris->nama_barang;

                    $result = '<div  class="fs_tabel ">'.$n_barang.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->inventaris_id == '' ? '-' :  $row->inventaris->merek;

                    $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                    return $result;
                })
                ->addColumn('nomor_seri', function ($row) {
                    $result = '<div  class="fs_tabel ">'.$row->nomor_seri.'</div>';

                    return $result;
                })
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->inventaris_id == '' ? '-' :  $row->inventaris->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                    return $result;
                })
                ->addColumn('sub_divisi', function ($row) {
                    $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                    $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                    return $result;
                })
                ->addColumn('proyek', function ($row) {
                    $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                    $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->kode_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('perusahaan', function ($row) {
                    $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                    $result = '<div  class="fs_tabel ">'.$perusahaan.'</div>';

                    return $result;
                })
                ->addColumn('created_at', function ($row) {
                    $tanggal_input = $row->created_at == '' ? '-' : Carbon::parse($row->creted_at)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal_input.'</div>';

                    return $result;
                })
                ->addColumn('gambar', function ($row) {
                    $gambar = $row->image == '' ? '-' : $row->image;

                    $result = '<a target="_blank" rel="noopener noreferrer" href="/inventaris_masuk/view_gambar/'.$row->id.'"  class="text-center "><i class="bi bi-card-image"></i></a>';

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/inventaris/show_barang_masuk/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/inventaris/inventaris/masuk/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'barang', 
                    'nama_barang', 
                    'merek', 
                    'nomor_seri', 
                    'kategori', 
                    'sub_divisi', 
                    'proyek',
                    'divisi',
                    'perusahaan',
                    'created_at',
                    'gambar',
                    'opsi',
                    ])->make(true);
        }
    }

    public function print(Request $request, $id)
    {

        // dd($id);
        if ($request->tglawal) {
            $data['data'] = Inventaris_In::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();;
        } else {
            $data['data'] = Inventaris_In::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
        }

        $item = Sub_Divisi::where('id', $id)->first();

        $data["title"] = "Print Barang Masuk";
        $data['web'] = Inventaris_In::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('admin_area.menu.inventaris.masuk.print', $data, [
            'item' => $item
        ]);
    }

    public function cari_barang($id)
    {

        // dd($id);
        // $data = Gs_Barangs::orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Inventaris::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc');
        // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('kode_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('sub_divisi_id', $id)->where('nama_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('sub_divisi_id', $id)->where('merek', 'like', '%' . request('cari_barang') . '%');
        }
        return view('admin_area.menu.inventaris.masuk.barang', [
            'data_data' => $data_data,
            'data' => $data->paginate(),
        ]);
    }

    public function data_barang($id) 
    {
 
         $data = Inventaris::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc');
 
         return view('admin_area.menu.inventaris.masuk.data_barang')->with([
             'data' => $data->paginate(15)
         ]);
    }
 
    public function search(Request $request, $id) 
    {
         $barang = $request->barang;
         $result = Inventaris::where('sub_divisi_id', $id)->where('kode_barang', 'like', '%'.$barang.'%', )->orwhere('sub_divisi_id', $id)->where('nama_barang', 'like', '%'.$barang.'%', )->orwhere('sub_divisi_id', $id)->where('merek', 'like', '%'.$barang.'%', )->get();
         // $result = Consumable::where('sub_divisi_id', $id)->where('nama_barang', 'like', '%'.$barang.'%' )->get();
         // $result = Consumable::where('sub_divisi_id', $id)->where('merek', 'like', '%'.$barang.'%' )->get();
 
         $data = count($result);
         
         if($data == 0) {
             return '<p class="text-center"><i class="bi bi-search"></i> Opps !!! Barang Tidak ditemukan...</p>';
         }else{
             return view('admin_area.menu.inventaris.masuk.data_barang')->with([
                 'data' => $result
             ]);
         }
 
    }

    public function gambar($id)
    {
        return view('admin_area.menu.view_gambar', [
           
            'item' => Inventaris_In::find($id),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $data_data = Inventaris::where('id', $id)->first();

        return view('admin_area.menu.inventaris.masuk.add', [
            'data_data' =>  $data_data,
            'perusahaan' =>  Perusahaan::all()
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //

        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'inventaris_id' => 'required',
            'aset' => 'required',
            'nomor_seri' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'suplayer' => 'required',
            'tanggal' => 'required',
            'lokasi' => 'required',
            'keterangan' => 'required',
            'image' => 'required|image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);

        if($request->file('image')) {
            // $data['image'] = $request->file('image')->store('post-image');
            $data['image'] = $request->file('image')->store('image', 'public');
        }

        // dd($data);


        Inventaris_In::create($data);
        return redirect('/inventaris/inventaris/masuk/'.$id)->with('toast_success', 'Data Barang DItambahkan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('admin_area.menu.inventaris.masuk.edit', [
            'data_data' =>  Inventaris_In::find($id),
            'perusahaan' =>  Perusahaan::all()
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
      
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'gs_barang_id' => 'required',
            'aset' => 'required',
            'nomor_seri' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'suplayer' => 'required',
            'tanggal' => 'required',
            'lokasi' => 'required',
            'keterangan' => 'required',
            'image' => 'image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);

        if($request->file('image')) {
            if($request->imagelama) {
                Storage::delete($request->imagelama);
            }
                // Storage::delete($request->gambarlama);

            // $data['image'] = $request->file('image')->store('post-image');
            $data['image'] = $request->file('image')->store('image');
        }

        // dd($data);
        Inventaris_In::where('id', $id)->update($data);
        return redirect('/inventaris/inventaris/masuk/'.$it)->with('toast_success', 'Data Barang di Update ');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        // $item = Inventaris_In::where('id', $id)->first();
        Inventaris_In::destroy($id);
        // Inventaris_Out::where('inventaris_id','=', $item->inventaris_id)->delete();

        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
