<?php

namespace App\Http\Controllers\Admin_Area\Inventaris;

use App\Http\Controllers\Controller;
use App\Models\Inventaris\Inventaris;
use App\Models\Inventaris\Inventaris_In;
use App\Models\Inventaris\Inventaris_Out;
use App\Models\Inventaris\Perawatan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Inventaris_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        $data_data = Sub_Divisi::where('id', $id)->first();

        $jumlah_barang = Inventaris::where('sub_divisi_id', $id)->count('id');
        // $jumlah_masuk = Consumable_In::where('sub_divisi_id', $id)->count('id');
        // $jumlah_keluar = Consumable_Out::where('sub_divisi_id', $id)->count('id');
        $mytime = Carbon::now();
        $jumlah_perawatan = Perawatan::where('sub_divisi_id', $id)->where('servis_berikutnya', '<=', $mytime)->count('servis_berikutnya');

        return view('admin_area.menu.inventaris.index', [
            'data_data' => $data_data,
            'id' => $id,
            'jumlah_barang' => $jumlah_barang,
            'jumlah_perawatan' => $jumlah_perawatan,
            // 'jumlah_keluar' => $jumlah_keluar,


            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    public function get_data(Request $request, $id)
    {
        // $data_proyek = Proyek::where('id', $id)->first();
        // $data_perusahaan = Sub_Divisi::where('divisi_id', '1')->first();

        // $id_perusahaan = $data_perusahaan->divisi->perusahaan->id;
        // $id_divisi = $data_perusahaan->divisi_id;
        // $id_sub_divisi = $data_perusahaan->id;

        if ($request->ajax()) {
            // $sub_divisi = Sub_Divisi::where('kode_sub_divisi', $id)->first();
            // $data = Consumable::orderBy('id', 'DESC')->get();
            $data = Inventaris::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc')->get();
            // ->where('sub_divisi_id', $id_sub_divisi)
            // ->where('proyek_id', $data_proyek->id)->orderBy('kode_barang', 'asc');

            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('stokawal', function ($row) {
                    $result = '<div class=""> <p class=fs-6> ' . $row->kode_barang . ' </p></div>';
                    // $result = '<a href="example.com/member/">'.$row->kode_barang.'</a>';

                    return $result;
                })
                ->addColumn('kode', function ($row) {
                    $result = '<a href="/inventaris/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="text-decoration-none fw-bold " style="font-size: 14px">'.$row->kode_barang.'</a>';

                    return $result;
                })
                ->addColumn('jmlmasuk', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Inventaris_In::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__ins.inventaris_id')
                            ->where('inventaris__ins.inventaris_id', '=', $row->id)
                            ->sum('inventaris__ins.jumlah');
                    } else {
                        $jmlmasuk = Inventaris_In::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__ins.inventaris_id')
                            ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                            ->where('inventaris__ins.inventaris_id', '=', $row->id)
                            ->sum('inventaris__ins.jumlah');
                    }

                    $result = '<span class="">' . $jmlmasuk . '</span>';

                    return $result;
                })
                ->addColumn('jmlkeluar', function ($row) use ($request) {
                    if ($request->tglawal) {
                        $jmlkeluar = Inventaris_Out::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__outs.inventaris_id')
                            ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                            ->where('inventaris__outs.inventaris_id', '=', $row->id)
                            ->sum('inventaris__outs.jumlah');
                    } else {
                        $jmlkeluar = Inventaris_Out::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__outs.inventaris_id')
                        ->where('inventaris__outs.inventaris_id', '=', $row->id)
                        ->sum('inventaris__outs.jumlah');
                    }

                    $result = '<span class="">' . $jmlkeluar . '</span>';

                    return $result;
                })
                ->addColumn('jumlah', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Inventaris_In::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__ins.inventaris_id')
                        ->where('inventaris__ins.inventaris_id', '=', $row->id)
                        ->sum('inventaris__ins.jumlah');
                    } else {
                        $jmlmasuk = Inventaris_In::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__ins.inventaris_id')
                        ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                        ->where('inventaris__ins.inventaris_id', '=', $row->id)
                        ->sum('inventaris__ins.jumlah');
                        // $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }

                    if ($request->tglawal) {
                        $jmlkeluar = Inventaris_Out::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__outs.inventaris_id')
                        ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                        ->where('inventaris__outs.inventaris_id', '=', $row->id)
                        ->sum('inventaris__outs.jumlah');
                        // $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Inventaris_Out::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__outs.inventaris_id')
                        ->where('inventaris__outs.inventaris_id', '=', $row->id)
                        ->sum('inventaris__outs.jumlah');
                    }

                    $totalstok = $jmlmasuk - $jmlkeluar;
                    if ($totalstok == 0) {
                        $result = '<span class="">' . $totalstok . '</span>';
                    } elseif ($totalstok > 0) {
                        $result = '<span class="text-success">' . $totalstok . '</span>';
                    } else {
                        $result = '<span class="text-danger">' . $totalstok . '</span>';
                    }

                    return $result;
                })
                ->addColumn('totalstok', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Inventaris_In::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__ins.inventaris_id')
                        ->where('inventaris__ins.inventaris_id', '=', $row->id)
                        ->sum('inventaris__ins.jumlah');
                    } else {
                        $jmlmasuk = Inventaris_In::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__ins.inventaris_id')
                        ->where('inventaris__ins.inventaris_id', '=', $row->id)
                        ->sum('inventaris__ins.jumlah');
                        // $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }

                    if ($request->tglawal) {
                        $jmlkeluar = Inventaris_Out::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__outs.inventaris_id')
                        ->where('inventaris__outs.inventaris_id', '=', $row->id)
                        ->sum('inventaris__outs.jumlah');
                        // $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Inventaris_Out::leftJoin('inventaris', 'inventaris.id', '=', 'inventaris__outs.inventaris_id')
                        ->where('inventaris__outs.inventaris_id', '=', $row->id)
                        ->sum('inventaris__outs.jumlah');
                    }

                    $totalstok = $jmlmasuk - $jmlkeluar;
                    if ($totalstok == 0) {
                        $result = '<span class="">' . $totalstok . '</span>';
                    } elseif ($totalstok > 0) {
                        $result = '<span class="text-success">' . $totalstok . '</span>';
                    } else {
                        $result = '<span class="text-danger">' . $totalstok . '</span>';
                    }

                    return $result;
                })
                
                ->addColumn('opsi', function ($row) {
                    // $result = '<span class="badge badge-success text-primary"> '.$row->id.'</span>';
                    $result = '<div class=""><a class="badge-edit text-light text-decoration-none" href="/inventaris/show/' . $row->id . '/' . $row->sub_divisi_id . '">Detail</a></div>';

                    return $result;
                })
                ->rawColumns(['kode','stokawal', 'jmlmasuk', 'jmlkeluar', 'totalstok', 'opsi'])
                ->make(true);
        }
    }

    public function print(Request $request, $id)
    {
        $data['data'] = Inventaris::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc')->get();

        $item = Sub_Divisi::where('id', $id)->first();

        $data['title'] = 'Print Barang Masuk';
        $data['web'] = Inventaris::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('admin_area.menu.inventaris.print', $data, [
            'item' => $item
        ]);
    }

    public function show(string $id, $it)
    {
        //
        $data_data = Sub_Divisi::where('id', $it)->first();
        $barang = Inventaris::where('id', $id )->first();

        // dd($barang);

        $in_barang = Inventaris_In::where('inventaris_id', $barang->id)->orderBy('id', 'desc');
        $out_barang = Inventaris_Out::where('inventaris_id', $barang->id)->orderBy('id', 'desc');
        
        $masuk = Inventaris_In::where('inventaris_id', $barang->id)->sum('jumlah');
        $keluar = Inventaris_Out::where('inventaris_id', $barang->id)->sum('jumlah');

        return view('admin_area.menu.inventaris.show', [
            'data_data' => $data_data,
        //   'data' => $data,
            'barang' => $barang,
            'in_barang' => $in_barang->paginate(10),
            'out_barang' => $out_barang->paginate(10),
            'masuk' => $masuk,
            'keluar' => $keluar


        ]);
    }

    public function gambar($id)
    {
        return view('admin_area.menu.view_gambar', [
           
            'item' => Inventaris_In::find($id),
        ]);
    }
}
