<?php

namespace App\Http\Controllers\Admin_Area\Inventaris;

use App\Http\Controllers\Controller;
use App\Models\Inventaris\Inventaris;
use App\Models\Inventaris\Inventaris_In;
use App\Models\Inventaris\Inventaris_Out;
use App\Models\Inventaris\Perawatan;
use App\Models\Inventaris\Perawatan_Riwayat;
use App\Models\Kategori;
use App\Models\Roles;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Inventaris_Barang_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Inventaris::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        if (request('search')) {
            $data->where('kode_barang', 'like', '%' . request('search') . '%')
            ->orWhere('nama_barang', 'like', '%' . request('search') . '%')
            ->orWhere('merek', 'like', '%' . request('search') . '%');
        }

        return view('admin_area.menu.inventaris.barang.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Inventaris::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Inventaris::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('barang', function ($row) {
                    $result = '<a href="/inventaris_barang/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$row->kode_barang.'</a>';

                    return $result;
                })
                ->addColumn('nama_barang', function ($row) {
                    $result = '<div  class="fs_tabel ">'.$row->nama_barang.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $result = '<div  class="fs_tabel ">'.$row->merek.'</div>';

                    return $result;
                })
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->kategori_id == '' ? '-' :  $row->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                    return $result;
                })
                ->addColumn('sub_divisi', function ($row) {
                    $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                    $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                    return $result;
                })
                ->addColumn('proyek', function ($row) {
                    $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                    $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->kode_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('perusahaan', function ($row) {
                    $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                    $result = '<div  class="fs_tabel ">'.$perusahaan.'</div>';

                    return $result;
                })
               
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/inventaris_barang/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/inventaris_barang/delete/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'barang', 
                    'nama_barang', 
                    'merek', 
                    'kategori', 
                    'sub_divisi', 
                    'proyek',
                    'divisi',
                    'perusahaan',
                    'opsi',
                    ])->make(true);
        }
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();
        $id = auth()->user()->id;
        $roles = Roles::where('user_id', $id)->first();
        $kategori = Kategori::where('proyek_id', $roles->proyek_id)->get();

        return view('admin_area.menu.inventaris.barang.add', [
            'data_data' =>  $data_data,
            'kategori' =>  $kategori
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_barang' => 'required|unique:inventaris',
            'nama_barang' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Inventaris::create($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/inventaris/inventaris/barang/'.$id)->with('toast_success', 'Data Barang DItambahkan');
     
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        $data = Inventaris::where('id', $id)->first();

        return view('admin_area.menu.inventaris.barang.edit', [
            // 'data_data' =>  $data_data,
            'data' => $data,
            'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_barang' => 'required',
            'nama_barang' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Inventaris::where('id', $id)->update($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/inventaris/inventaris/barang/'.$it)->with('toast_success', 'Data Barang Di Update');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Inventaris::destroy($id);
        Inventaris_In::where('inventaris_id','=', $id)->delete();
        Inventaris_Out::where('inventaris_id','=', $id)->delete();
        Perawatan::where('inventaris_id','=', $id)->delete();
        Perawatan_Riwayat::where('inventaris_id','=', $id)->delete();
        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
