<?php

namespace App\Http\Controllers\Admin_Area\Consumable;

use App\Http\Controllers\Controller;
use App\Models\Consumable\Consumable;
use App\Models\Consumable\Consumable_In;
use App\Models\Consumable\Consumable_Out;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Consumable_Out_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Consumable_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        return view('admin_area.menu.consumable.keluar.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            // 'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
             
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */

     public function get_data(Request $request, $id) 
     {
 
         if ($request->ajax()) {
             if ($request->tglawal == '') {
                 $data = Consumable_Out::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
             } else {
                 $data = Consumable_Out::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
             }
             return DataTables::of($data)
             ->addIndexColumn()
             ->addColumn('tanggal', function ($row) {
                 $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                 $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                 return $result;
             })
             ->addColumn('barang', function ($row) {
                 $barang = $row->consumable_id == '' ? '-' :  $row->consumable->kode_barang;

                 $result = '<a href="/consumable/show_barang_keluar/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$barang.'</a>';

                 return $result;
             })
             ->addColumn('nama_barang', function ($row) {
                 $n_barang = $row->consumable_id == '' ? '-' :  $row->consumable->nama_barang;

                 $result = '<div  class="fs_tabel ">'.$n_barang.'</div>';

                 return $result;
             })
             ->addColumn('merek', function ($row) {
                 $merek = $row->consumable_id == '' ? '-' :  $row->consumable->merek;

                 $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                 return $result;
             })
             ->addColumn('kategori', function ($row) {
                 $kategori = $row->consumable_id == '' ? '-' :  $row->consumable->kategori->nama_kategori;

                 $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                 return $result;
             })
           
             ->addColumn('sub_divisi', function ($row) {
                 $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                 $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                 return $result;
             })
             ->addColumn('proyek', function ($row) {
                 $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                 $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                 return $result;
             })
             ->addColumn('divisi', function ($row) {
                 $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->nama_divisi;

                 $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                 return $result;
             })
             ->addColumn('perusahaan', function ($row) {
                 $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                 $result = '<div  class="fs_tabel text-center">'.$perusahaan.'</div>';

                 return $result;
             })
             ->addColumn('created_at', function ($row) {
                 $tanggal_input = $row->created_at == '' ? '-' : Carbon::parse($row->creted_at)->translatedFormat('d-m-Y');

                 $result = '<div  class="fs_tabel ">'.$tanggal_input.'</div>';

                 return $result;
             })
             ->addColumn('opsi', function ($row) {
                 $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                 <a href="/consumable/show_barang_masuk/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                 <a href="/consumable/consumable/keluar/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                 </div>';

                 return $result;
             })
             ->rawColumns([
                 'tanggal', 
                 'barang', 
                 'nama_barang', 
                 'merek', 
                 'kategori', 
                 'sub_divisi', 
                 'proyek',
                 'divisi',
                 'perusahaan',
                 'created_at',
                 'gambar',
                 'opsi',
                 ])->make(true);
         }
     }

     public function print(Request $request, $id)
     {
 
         // dd($id);
         if ($request->tglawal) {
             $data['data'] = Consumable_Out::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();;
         } else {
             $data['data'] = Consumable_Out::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
         }
 
         $item = Sub_Divisi::where('id', $id)->first();
 
         $data["title"] = "Print Barang Keluar";
         $data['web'] = Consumable_Out::first();
         $data['tglawal'] = $request->tglawal;
         $data['tglakhir'] = $request->tglakhir;
         return view('admin_area.menu.consumable.keluar.print', $data, [
             'item' => $item
         ]);
     }


     public function cari_barang($id)
     {
 
         // dd($id);
         // $data = Gs_Barangs::orderBy('id', 'asc');
         $data_data = Sub_Divisi::where('id', $id)->first();
 
         $data = Consumable::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc');
         // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
         // $data = Gs_Barangs::orderBy('id', 'asc');
 
         if (request('cari_barang')) {
            $data->where('kode_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('sub_divisi_id', $id)->where('nama_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('sub_divisi_id', $id)->where('merek', 'like', '%' . request('cari_barang') . '%');
        }
         return view('admin_area.menu.consumable.keluar.barang', [
             'data_data' => $data_data,
             'data' => $data->paginate(),
         ]);
     }

     public function data_barang($id) 
     {
  
          $data = Consumable::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc');
  
          return view('admin_area.menu.consumable.keluar.data_barang')->with([
              'data' => $data->paginate(15)
          ]);
     }
  
     public function search(Request $request, $id) 
     {
          $barang = $request->barang;
          $result = Consumable::where('sub_divisi_id', $id)->where('kode_barang', 'like', '%'.$barang.'%', )->orwhere('sub_divisi_id', $id)->where('nama_barang', 'like', '%'.$barang.'%', )->orwhere('sub_divisi_id', $id)->where('merek', 'like', '%'.$barang.'%', )->get();
          // $result = Consumable::where('sub_divisi_id', $id)->where('nama_barang', 'like', '%'.$barang.'%' )->get();
          // $result = Consumable::where('sub_divisi_id', $id)->where('merek', 'like', '%'.$barang.'%' )->get();
  
          $data = count($result);
          
          if($data == 0) {
              return '<p class="text-center"><i class="bi bi-search"></i> Opps !!! Barang Tidak ditemukan...</p>';
          }else{
              return view('admin_area.menu.consumable.keluar.data_barang')->with([
                  'data' => $result
              ]);
          }
  
     }

     public function get_data_barang(Request $request, $id) 
   {

       if ($request->ajax()) {
           if ($request->tglawal == '') {
               $data = Consumable::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
           } else {
               $data = Consumable::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
           }
           return DataTables::of($data)
               ->addIndexColumn()
               ->addColumn('barang', function ($row) {
                   $result = '<a href="/consumable/add_barang_keluar/'.$row->id.'" class="fs_tabel fw-bold ">'.$row->kode_barang.'</a>';

                   return $result;
               })
               ->addColumn('nama_barang', function ($row) {
                   $result = '<div  class="fs_tabel ">'.$row->nama_barang.'</div>';

                   return $result;
               })
               ->addColumn('merek', function ($row) {
                   $result = '<div  class="fs_tabel ">'.$row->merek.'</div>';

                   return $result;
               })
               ->addColumn('kategori', function ($row) {
                   $kategori = $row->kategori_id == '' ? '-' :  $row->kategori->nama_kategori;

                   $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                   return $result;
               })
              
               ->addColumn('opsi', function ($row) {
                   $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                   <a href="/consumable/add_barang_keluar/'.$row->id.'" class="badge bg-primary text-light me-1 text-decoration-none">Pilih</a>
                   
                   </div>';

                   return $result;
               })
               ->rawColumns([
                   'tanggal', 
                   'barang', 
                   'nama_barang', 
                   'merek', 
                   'kategori', 
                   'opsi',
                   ])->make(true);
       }
   }


    public function create($id)
    {
        //
        $data_data = Consumable::where('id', $id)->first();

        return view('admin_area.menu.consumable.keluar.add', [
            'data_data' =>  $data_data,
            'perusahaan' => Perusahaan::all(),
            'divisi' => Divisi::all()
            // 'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'consumable_id' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'nama' => 'required',
            'nik' => 'required',
            'n_divisi' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'status' => 'required',
            'keterangan' => 'required',
        ]);

        // dd($data);
        Consumable_Out::create($data);
        return redirect('/consumable/consumable/keluar/'.$id)->with('toast_success', 'Data Ditambahkan !');

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('admin_area.menu.consumable.keluar.edit', [
            'data_data' =>  Consumable_Out::find($id),
            'perusahaan' => Perusahaan::all()
            // 'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            // 'gs_barang_id' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'nama' => 'required',
            'nik' => 'required',
            'n_divisi' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'status' => 'required',
            'keterangan' => 'required',
        ]);

        // dd($data);
        Consumable_Out::where('id', $id)->update($data);
        return redirect('/consumable/consumable/keluar/'.$it)->with('toast_success', 'Data di Update !');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Consumable_Out::destroy($id);
        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
