<?php

namespace App\Http\Controllers\Admin_Area;

use App\Http\Controllers\Controller;
use App\Models\Roles;
use App\Models\Superadmin\Sub_Divisi;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class Admin_Profil_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $auth = auth()->user()->id;
        $roles = Roles::where('user_id', $auth)->first();
        $menu = Sub_Divisi::where('proyek_id', $roles->proyek_id)->orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('proyek_id', $roles->proyek_id)->first();

        // if (request('search')) {
        //     $perusahaan->where('kode_divisi', 'like', '%' . request('search') . '%')->orWhere('nama_divisi', 'like', '%' . request('search') . '%');
        // }

        return view('admin_area.profil.index', [
            'nama_menu' => 'Perusahaan',
            'menu' => $menu->paginate(),
            'data_data' => $data_data,
            'data' => $roles,

            
            // $title = 'Hapus Data',
            // $text = "Apakah anda yakin ingin menghapus?",
            // confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            'name' => 'required',
            'username' => 'required',
            'password' => 'required|min:4',
            // 'level' => 'required',
        ]);

        $data['password'] = Hash::make($data['password']);
        User::where('id', $id)->update($data);
        return back()->with('toast_success', 'Akun Berhasil Di Update ');
  
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
